package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.BzscYsjglggzscCb;
import com.qianhe.domain.BzscYsjglggzscZb;
import com.qianhe.mapper.BzscYsjglggzscZbMapper;
import com.qianhe.service.IBzscYsjglggzscZbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;


/**
 * 标准手册-油水井管理岗工作手册-主Service业务层处理
 *
 * @author qianhe
 * @date 2024-10-09
 */
@Service
public class BzscYsjglggzscZbServiceImpl implements IBzscYsjglggzscZbService
{
    @Autowired
    private BzscYsjglggzscZbMapper bzscYsjglggzscZbMapper;

    /**
     * 查询标准手册-油水井管理岗工作手册-主
     *
     * @param ID 标准手册-油水井管理岗工作手册-主主键
     * @return 标准手册-油水井管理岗工作手册-主
     */
    @Override
    public BzscYsjglggzscZb selectBzscYsjglggzscZbByID(Long ID)
    {
        return bzscYsjglggzscZbMapper.selectBzscYsjglggzscZbByID(ID);
    }

    /**
     * 查询标准手册-油水井管理岗工作手册-主列表
     *
     * @param bzscYsjglggzscZb 标准手册-油水井管理岗工作手册-主
     * @return 标准手册-油水井管理岗工作手册-主
     */
    @Override
    public List<BzscYsjglggzscZb> selectBzscYsjglggzscZbList(BzscYsjglggzscZb bzscYsjglggzscZb)
    {
        return bzscYsjglggzscZbMapper.selectBzscYsjglggzscZbList(bzscYsjglggzscZb);
    }

    /**
     * 新增标准手册-油水井管理岗工作手册-主
     *
     * @param bzscYsjglggzscZb 标准手册-油水井管理岗工作手册-主
     * @return 结果
     */
    @Transactional
    @Override
    public int insertBzscYsjglggzscZb(BzscYsjglggzscZb bzscYsjglggzscZb)
    {
        bzscYsjglggzscZb.setCreateTime(DateUtils.getNowDate());
        int rows = bzscYsjglggzscZbMapper.insertBzscYsjglggzscZb(bzscYsjglggzscZb);
        insertBzscYsjglggzscCb(bzscYsjglggzscZb);
        return rows;
    }

    /**
     * 修改标准手册-油水井管理岗工作手册-主
     *
     * @param bzscYsjglggzscZb 标准手册-油水井管理岗工作手册-主
     * @return 结果
     */
    @Transactional
    @Override
    public int updateBzscYsjglggzscZb(BzscYsjglggzscZb bzscYsjglggzscZb)
    {
        bzscYsjglggzscZb.setUpdateTime(DateUtils.getNowDate());
        bzscYsjglggzscZbMapper.deleteBzscYsjglggzscCbByZbId(bzscYsjglggzscZb.getID());
        insertBzscYsjglggzscCb(bzscYsjglggzscZb);
        return bzscYsjglggzscZbMapper.updateBzscYsjglggzscZb(bzscYsjglggzscZb);
    }

    /**
     * 批量删除标准手册-油水井管理岗工作手册-主
     *
     * @param IDs 需要删除的标准手册-油水井管理岗工作手册-主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteBzscYsjglggzscZbByIDs(Long[] IDs)
    {
        bzscYsjglggzscZbMapper.deleteBzscYsjglggzscCbByZbIds(IDs);
        return bzscYsjglggzscZbMapper.deleteBzscYsjglggzscZbByIDs(IDs);
    }

    /**
     * 删除标准手册-油水井管理岗工作手册-主信息
     *
     * @param ID 标准手册-油水井管理岗工作手册-主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteBzscYsjglggzscZbByID(Long ID)
    {
        bzscYsjglggzscZbMapper.deleteBzscYsjglggzscCbByZbId(ID);
        return bzscYsjglggzscZbMapper.deleteBzscYsjglggzscZbByID(ID);
    }

    /**
     * 新增标准手册-油水井管理岗工作手册-从信息
     *
     * @param bzscYsjglggzscZb 标准手册-油水井管理岗工作手册-主对象
     */
    public void insertBzscYsjglggzscCb(BzscYsjglggzscZb bzscYsjglggzscZb)
    {
        List<BzscYsjglggzscCb> bzscYsjglggzscCbList = bzscYsjglggzscZb.getBzscYsjglggzscCbList();
        Long ID = bzscYsjglggzscZb.getID();
        if (StringUtils.isNotNull(bzscYsjglggzscCbList))
        {
            List<BzscYsjglggzscCb> list = new ArrayList<BzscYsjglggzscCb>();
            for (BzscYsjglggzscCb bzscYsjglggzscCb : bzscYsjglggzscCbList)
            {
                bzscYsjglggzscCb.setZbId(ID);
                list.add(bzscYsjglggzscCb);
            }
            if (list.size() > 0)
            {
                bzscYsjglggzscZbMapper.batchBzscYsjglggzscCb(list);
            }
        }
    }
}
