package com.qianhe.domain;

import java.math.BigDecimal;
import java.util.List;

import com.qianhe.domain.SjFybpWh;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 三基-费用报批对象 sj_fybp
 *
 * @author qianhe
 * @date 2024-07-05
 */
@Data
public class SjFybp extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;
    private Long zbId;

    /** 费用名称 */
    @Excel(name = "费用名称")
    private String fymc;

    /** 费用日期 */
    @Excel(name = "费用日期")
    private String fyrq;

    /** 单位 */
    @Excel(name = "单位")
    private String deptId;

    /** 费用类型 */
    @Excel(name = "费用类型")
    private String fylx;

    /** 费用描述 */
    @Excel(name = "费用描述")
    private String fyms;

    /** 费用金额 */
    @Excel(name = "费用金额")
    private BigDecimal fyje;

    /** 文件关联id */
    @Excel(name = "文件关联id")
    private String fjid;

    /** 状态(未提交、待审批、已审批、已驳回) */
    @Excel(name = "状态(未提交、待审批、已审批、已驳回)")
    private String zt;
    private String spzt;

    /** 提交人 */
    @Excel(name = "提交人")
    private String tjr;
    @Excel(name = "提交日期")
    private String tjrq;

    /** 审批日期 */
    @Excel(name = "审批日期")
    private String sprq;

    /** 审批人 */
    @Excel(name = "审批人")
    private String spr;

    private String sprName;

    /** 批复金额 */
    @Excel(name = "批复金额")
    private BigDecimal pfje;

    /** 已使用金额 */
    @Excel(name = "已使用金额")
    private BigDecimal ysyje;

    /** 审批意见 */
    @Excel(name = "审批意见")
    private String spyj;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    //费用审批查询 （传1 查不等于未提交的数据，2查等于已批复的数据）
    private String spcx;

    private String deptName;
    private String startTime;
    private String endTime;


    //数量
    private Integer sl;


    private BigDecimal fyzje;

    //批复金额总和
    private BigDecimal pfjezh;
    //已使用金额总和
    private BigDecimal ysyjezh;

    /** 三基-费用维护信息 */
    private List<SjFybpWh> sjFybpWhList;

    private List<WdWdxx> fileList;


}
