package com.qianhe.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 三基帮扶组维护对象 sj_bfzwh
 *
 * @author qianhe
 * @date 2024-08-31
 */
public class SjBfzwh extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 帮扶组名称 */
    @Excel(name = "帮扶组名称")
    private String bfzmc;

    /** 联系人 */
    @Excel(name = "联系人")
    private String lxr;

    /** 年度 */
    @Excel(name = "年度")
    private String nd;

    /** 录入人 */
    @Excel(name = "录入人")
    private String lrr;

    /** 录入时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "录入时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lrsj;

    /** 修改人 */
    @Excel(name = "修改人")
    private String xgr;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "修改时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date xgsj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 单位组 */
    private Long[] deptIds;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setBfzmc(String bfzmc)
    {
        this.bfzmc = bfzmc;
    }

    public String getBfzmc()
    {
        return bfzmc;
    }
    public void setLxr(String lxr)
    {
        this.lxr = lxr;
    }

    public String getLxr()
    {
        return lxr;
    }
    public void setNd(String nd)
    {
        this.nd = nd;
    }

    public String getNd()
    {
        return nd;
    }
    public void setLrr(String lrr)
    {
        this.lrr = lrr;
    }

    public String getLrr()
    {
        return lrr;
    }
    public void setLrsj(Date lrsj)
    {
        this.lrsj = lrsj;
    }

    public Date getLrsj()
    {
        return lrsj;
    }
    public void setXgr(String xgr)
    {
        this.xgr = xgr;
    }

    public String getXgr()
    {
        return xgr;
    }
    public void setXgsj(Date xgsj)
    {
        this.xgsj = xgsj;
    }

    public Date getXgsj()
    {
        return xgsj;
    }
    public void setBz(String bz)
    {
        this.bz = bz;
    }

    public String getBz()
    {
        return bz;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("bfzmc", getBfzmc())
            .append("lxr", getLxr())
            .append("nd", getNd())
            .append("lrr", getLrr())
            .append("lrsj", getLrsj())
            .append("xgr", getXgr())
            .append("xgsj", getXgsj())
            .append("bz", getBz())
            .toString();
    }

    public Long[] getDeptIds() {
        return deptIds;
    }

    public void setDeptIds(Long[] deptIds) {
        this.deptIds = deptIds;
    }
}
