package com.qianhe.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 经验共享-文章管理对象 jygx_wzgl
 *
 * @author qianhe
 * @date 2024-07-29
 */
public class JygxWzgl extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long wzid;

    /** 排序 */
    @Excel(name = "排序")
    private Long px;

    /** 信息来源 */
    @Excel(name = "信息来源")
    private String xxly;

    /** 类型id */
    @Excel(name = "类型id")
    private Long lxid;

    /** 维护类型 */
    @Excel(name = "维护类型")
    private String lxmc;

    /** 文章内容 */
    @Excel(name = "文章内容")
    private String wznr;

    /** 文章标题 */
    @Excel(name = "文章标题")
    private String wzbt;

    /** 审核状态（0未提交/1已退回/2已提交/3审核通过未发布/4审核通过发布） */
    @Excel(name = "审核状态", readConverterExp = "0=未提交/1已退回/2已提交/3审核通过未发布/4审核通过发布")
    private String shzt;

    /** 封面附件名称 */
    @Excel(name = "封面附件名称")
    private String fjmc;

    /** 封面附件地址 */
    @Excel(name = "封面附件地址")
    private String fjdz;

    /** 封面附件类型 */
    @Excel(name = "封面附件类型")
    private String fjlx;

    /** 文章作者 */
    @Excel(name = "文章作者")
    private String wzzz;

    /** 文章时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "文章时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date wzsj;

    /** 预留1 */
    @Excel(name = "预留1")
    private Long deptId;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    /** 阅读数量 */
    @Excel(name = "阅读数量")
    private Long ydsl;


    /** 文章管理附件 */
    @Excel(name = "文章管理附件")
    private List<JygxWzglfj> jygxWzglfjList;

    public List<JygxWzglfj> getJygxWzglfjList() {
        return jygxWzglfjList;
    }

    public void setJygxWzglfjList(List<JygxWzglfj> jygxWzglfjList) {
        this.jygxWzglfjList = jygxWzglfjList;
    }

    public void setWzid(Long wzid)
    {
        this.wzid = wzid;
    }

    public Long getWzid()
    {
        return wzid;
    }
    public void setPx(Long px)
    {
        this.px = px;
    }

    public Long getPx()
    {
        return px;
    }
    public void setXxly(String xxly)
    {
        this.xxly = xxly;
    }

    public String getXxly()
    {
        return xxly;
    }
    public void setLxid(Long lxid)
    {
        this.lxid = lxid;
    }

    public Long getLxid()
    {
        return lxid;
    }
    public void setLxmc(String lxmc)
    {
        this.lxmc = lxmc;
    }

    public String getLxmc()
    {
        return lxmc;
    }
    public void setWznr(String wznr)
    {
        this.wznr = wznr;
    }

    public String getWznr()
    {
        return wznr;
    }
    public void setWzbt(String wzbt)
    {
        this.wzbt = wzbt;
    }

    public String getWzbt()
    {
        return wzbt;
    }
    public void setShzt(String shzt)
    {
        this.shzt = shzt;
    }

    public String getShzt()
    {
        return shzt;
    }
    public void setFjmc(String fjmc)
    {
        this.fjmc = fjmc;
    }

    public String getFjmc()
    {
        return fjmc;
    }
    public void setFjdz(String fjdz)
    {
        this.fjdz = fjdz;
    }

    public String getFjdz()
    {
        return fjdz;
    }
    public void setFjlx(String fjlx)
    {
        this.fjlx = fjlx;
    }

    public String getFjlx()
    {
        return fjlx;
    }
    public void setWzzz(String wzzz)
    {
        this.wzzz = wzzz;
    }

    public String getWzzz()
    {
        return wzzz;
    }
    public void setWzsj(Date wzsj)
    {
        this.wzsj = wzsj;
    }

    public Date getWzsj()
    {
        return wzsj;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public void setYl2(String yl2)
    {
        this.yl2 = yl2;
    }

    public String getYl2()
    {
        return yl2;
    }
    public void setYl3(String yl3)
    {
        this.yl3 = yl3;
    }

    public String getYl3()
    {
        return yl3;
    }
    public void setYl4(String yl4)
    {
        this.yl4 = yl4;
    }

    public String getYl4()
    {
        return yl4;
    }
    public void setYl5(String yl5)
    {
        this.yl5 = yl5;
    }

    public String getYl5()
    {
        return yl5;
    }
    public void setYdsl(Long ydsl)
    {
        this.ydsl = ydsl;
    }

    public Long getYdsl()
    {
        return ydsl;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("wzid", getWzid())
            .append("px", getPx())
            .append("xxly", getXxly())
            .append("lxid", getLxid())
            .append("lxmc", getLxmc())
            .append("wznr", getWznr())
            .append("wzbt", getWzbt())
            .append("shzt", getShzt())
            .append("fjmc", getFjmc())
            .append("fjdz", getFjdz())
            .append("fjlx", getFjlx())
            .append("wzzz", getWzzz())
            .append("wzsj", getWzsj())
            .append("deptId", getDeptId())
            .append("yl2", getYl2())
            .append("yl3", getYl3())
            .append("yl4", getYl4())
            .append("yl5", getYl5())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("ydsl", getYdsl())
            .toString();
    }
}
