package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.SjBfzwh;
import com.qianhe.service.ISjBfzwhService;
import com.qianhe.system.service.ISysDeptService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 三基帮扶组维护Controller
 *
 * @author qianhe
 * @date 2024-08-31
 */
@RestController
@RequestMapping("/system/bfzwh")
public class SjBfzwhController extends BaseController
{
    @Autowired
    private ISjBfzwhService sjBfzwhService;

    /**
     * 查询三基帮扶组维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:bfzwh:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjBfzwh sjBfzwh)
    {

        // 获取当前用户名
        String username = SecurityUtils.getUsername();
        if(username.equals("admin") || username.equals("sjgly") ){

        }else{
            sjBfzwh.setLxr(username);
        }
        startPage();
        List<SjBfzwh> list = sjBfzwhService.selectSjBfzwhList(sjBfzwh);
        return getDataTable(list);
    }

    /**
     * 查询三基帮扶组维护下拉框
     */
    @GetMapping("/xlklist")
    public TableDataInfo xlklist(SjBfzwh sjBfzwh)
    {

        // 获取当前用户名
        String username = SecurityUtils.getUsername();
        sjBfzwh.setLxr(username);

        List<SjBfzwh> list = sjBfzwhService.selectSjBfzwhList(sjBfzwh);
        return getDataTable(list);
    }

    /**
     * 导出三基帮扶组维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:bfzwh:export')")
    @Log(title = "三基帮扶组维护", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjBfzwh sjBfzwh)
    {
        // 获取当前用户名
        String username = SecurityUtils.getUsername();
        sjBfzwh.setLxr(username);
        List<SjBfzwh> list = sjBfzwhService.selectSjBfzwhList(sjBfzwh);
        ExcelUtil<SjBfzwh> util = new ExcelUtil<SjBfzwh>(SjBfzwh.class);
        util.exportExcel(response, list, "三基帮扶组维护数据");
    }

    /**
     * 获取三基帮扶组维护详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:bfzwh:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjBfzwhService.selectSjBfzwhById(id));
    }

    /**
     * 新增三基帮扶组维护
     */
    @PreAuthorize("@ss.hasPermi('system:bfzwh:add')")
    @Log(title = "三基帮扶组维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjBfzwh sjBfzwh)
    {
        return toAjax(sjBfzwhService.insertSjBfzwh(sjBfzwh));
    }

    /**
     * 修改三基帮扶组维护
     */
    @PreAuthorize("@ss.hasPermi('system:bfzwh:edit')")
    @Log(title = "三基帮扶组维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjBfzwh sjBfzwh)
    {
        return toAjax(sjBfzwhService.updateSjBfzwh(sjBfzwh));
    }

    /**
     * 删除三基帮扶组维护
     */
    @PreAuthorize("@ss.hasPermi('system:bfzwh:remove')")
    @Log(title = "三基帮扶组维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjBfzwhService.deleteSjBfzwhByIds(ids));
    }

    @Autowired
    private ISysDeptService deptService;
    /**
     * 加载对应帮扶组单位列表树
     */
    @GetMapping(value = "/bfzBfdxTreeselect/{id}")
    public AjaxResult roleMenuTreeselect(@PathVariable("id") Long id)
    {
        List<SysDept> depts = deptService.selectDeptList_sy(new SysDept());
        AjaxResult ajax = AjaxResult.success();
        ajax.put("checkedKeys", sjBfzwhService.selectBfdxListByBfz(id));
        ajax.put("menus", sjBfzwhService.buildBfdwTreeSelect(depts));
        return ajax;
    }

    /**
     * 获取菜单下拉树列表
     */
    @GetMapping("/deptTreeselect")
    public AjaxResult treeselect(SysDept dept)
    {
        List<SysDept> depts = deptService.selectDeptList_sy(new SysDept());
        return success(sjBfzwhService.buildBfdwTreeSelect(depts));
    }
}
