package com.qianhe.controller;


import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.entity.SysDictData;
import com.qianhe.common.core.domain.entity.SysDictType;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.domain.*;
import com.qianhe.service.IJygxBmjjService;
import com.qianhe.service.IJygxCljwhService;
import com.qianhe.service.IJygxWzglService;
import com.qianhe.service.IJygxYyxtwhService;
import com.qianhe.system.service.ISysDictDataService;
import com.qianhe.system.service.ISysDictTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


import java.util.List;

/**
 * 经验共享-应用系统维护Controller
 *
 * @author qianhe
 * @date 2024-07-29
 */
@RestController
@RequestMapping("/system/sy")
public class JygxSyController extends BaseController
{
    @Autowired
    private IJygxYyxtwhService jygxYyxtwhService;
    @Autowired
    private IJygxWzglService jygxWzglService;
    @Autowired
    private IJygxCljwhService jygxCljwhService;
    @Autowired
    private IJygxBmjjService jygxBmjjService;

    @Autowired
    private ISysDictDataService dictDataService;


    /**
     * 查询经验共享-文章管理列表
     */
    @GetMapping("/wzgllist")
    public TableDataInfo list(JygxWzgl jygxWzgl)
    {
        startPage();
        jygxWzgl.setShzt("4");
        List<JygxWzgl> list = jygxWzglService.selectList(jygxWzgl);
        return getDataTable(list);
    }

    /**
     * 查询经验共享-首页轮播图新闻
     */
    @GetMapping("/sylbxlist")
    public TableDataInfo sylbxlist(JygxWzgl jygxWzgl)
    {
        startPage();
        jygxWzgl.setShzt("4");
        List<JygxWzgl> list = jygxWzglService.selectSylbxwList(jygxWzgl);
        return getDataTable(list);
    }

    /**
     * 获取经验共享-文章管理详细信息
     */
    @GetMapping(value = "/wz/{wzid}")
    public AjaxResult getwzInfo(@PathVariable("wzid") Long wzid)
    {
        return success(jygxWzglService.selectsyWzid(wzid));
    }


    /**
     * 查询经验共享-应用系统维护列表
     */
    @GetMapping("/yyxtwhlist")
    public TableDataInfo list(JygxYyxtwh jygxYyxtwh)
    {
        jygxYyxtwh.setFbzt("4");
        List<JygxYyxtwh> list = jygxYyxtwhService.selectJygxYyxtwhList(jygxYyxtwh);
        return getDataTable(list);
    }

    /**
     * 查询经验共享-超链接维护列表
     */
    @GetMapping("/cljwhlist")
    public TableDataInfo list(JygxCljwh jygxCljwh)
    {
        jygxCljwh.setFbzt("4");
        List<JygxCljwh> list = jygxCljwhService.selectJygxCljwhList(jygxCljwh);
        return getDataTable(list);
    }

    /**
     * 获取经验共享-组织领导详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(jygxBmjjService.selectJygxBmjjById(id));
    }



    /**
     * 首页搜索类型条数
     */
    @GetMapping("/sysslx")
    public TableDataInfo sysslx(JygxWzgl jygxWzgl)
    {
        List<Ssfl> list = jygxWzglService.selectcxflList(jygxWzgl);
        return getDataTable(list);
    }

    /**
     * 首页搜索
     */
    @GetMapping("/syss")
    public TableDataInfo syss(JygxWzgl jygxWzgl)
    {
        startPage();
        List<JygxWzgl> list = jygxWzglService.selectsyssList(jygxWzgl);
        return getDataTable(list);
    }


    /**
     * 首页经验交流
     */
    @GetMapping("/syjyjl")
    public TableDataInfo syjyjl()
    {
        List<Jyjl> list = jygxWzglService.selectjyjlList();
        return getDataTable(list);
    }





    @GetMapping("/dict")
    public TableDataInfo dict()
    {
        SysDictData dictData = new SysDictData();
        dictData.setDictType("sylx");
        List<SysDictData> list = dictDataService.selectDictDataList(dictData);
        return getDataTable(list);
    }



}
