package com.qianhe.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.BzscCyglqglscCb;
import com.qianhe.domain.BzscZczscCb;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.BzscZczscZb;
import com.qianhe.service.IBzscZczscZbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-注采站管理手册-主Controller
 *
 * @author qianhe
 * @date 2024-09-11
 */
@RestController
@RequestMapping("/system/bzscZczscZb")
public class BzscZczscZbController extends BaseController
{
    @Autowired
    private IBzscZczscZbService bzscZczscZbService;

    /**
     * 查询标准手册-注采站管理手册-主列表
     */
    @PreAuthorize("@ss.hasPermi('system:bzscZczscZb:list')")
    @GetMapping("/list")
    public TableDataInfo list(BzscZczscZb bzscZczscZb)
    {
        startPage();
        List<BzscZczscZb> list = bzscZczscZbService.selectBzscZczscZbList(bzscZczscZb);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-注采站管理手册-主列表
     */
    @PreAuthorize("@ss.hasPermi('system:bzscZczscZb:export')")
    @Log(title = "标准手册-注采站管理手册-主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscZczscZb bzscZczscZb)
    {
        List<BzscZczscZb> list = bzscZczscZbService.selectBzscZczscZbList(bzscZczscZb);
        ExcelUtil<BzscZczscZb> util = new ExcelUtil<BzscZczscZb>(BzscZczscZb.class);
        util.exportExcel(response, list, "标准手册-注采站管理手册-主数据");
    }

    /**
     * 获取标准手册-注采站管理手册-主详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:bzscZczscZb:query')")
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        BzscZczscZb bzscZczscZb = bzscZczscZbService.selectBzscZczscZbByID(ID);
        Map<String,Object> map =new HashMap<>();
        BzscZczscCb cb = bzscZczscZb.getBzscZczscCbList().size() > 0 ? bzscZczscZb.getBzscZczscCbList().get(0) : null;
        map.put("nr",cb!=null ?cb.getChildList():new ArrayList<BzscZczscCb>());
        if(cb!=null){
            cb.setChildList(new ArrayList<>());
        }
        map.put("bt",cb);
        bzscZczscZb.setBzscZczscCbList(new ArrayList<>());
        map.put("bzscZczscZb",bzscZczscZb);
        return success(map );
    }

    /**
     * 新增标准手册-注采站管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscZczscZb:add')")
    @Log(title = "标准手册-注采站管理手册-主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscZczscZb bzscZczscZb)
    {
        return toAjax(bzscZczscZbService.insertBzscZczscZb(bzscZczscZb));
    }

    /**
     * 修改标准手册-注采站管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscZczscZb:edit')")
    @Log(title = "标准手册-注采站管理手册-主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscZczscZb bzscZczscZb)
    {
        return toAjax(bzscZczscZbService.updateBzscZczscZb(bzscZczscZb));
    }

    /**
     * 删除标准手册-注采站管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscZczscZb:remove')")
    @Log(title = "标准手册-注采站管理手册-主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{IDs}")
    public AjaxResult remove(@PathVariable Long[] IDs)
    {
        return toAjax(bzscZczscZbService.deleteBzscZczscZbByIDs(IDs));
    }
}
