package com.qianhe.system.mapper;

import java.util.List;
import com.qianhe.system.domain.SysDeptFl;

/**
 * 单位分类Mapper接口
 * 
 * @author qianhe
 * @date 2024-07-22
 */
public interface SysDeptFlMapper 
{
    /**
     * 查询单位分类
     * 
     * @param id 单位分类主键
     * @return 单位分类
     */
    public SysDeptFl selectSysDeptFlById(Long id);

    /**
     * 查询单位分类列表
     * 
     * @param sysDeptFl 单位分类
     * @return 单位分类集合
     */
    public List<SysDeptFl> selectSysDeptFlList(SysDeptFl sysDeptFl);

    /**
     * 新增单位分类
     * 
     * @param sysDeptFl 单位分类
     * @return 结果
     */
    public int insertSysDeptFl(SysDeptFl sysDeptFl);

    /**
     * 修改单位分类
     * 
     * @param sysDeptFl 单位分类
     * @return 结果
     */
    public int updateSysDeptFl(SysDeptFl sysDeptFl);

    /**
     * 删除单位分类
     * 
     * @param id 单位分类主键
     * @return 结果
     */
    public int deleteSysDeptFlById(Long id);

    /**
     * 批量删除单位分类
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysDeptFlByIds(Long[] ids);
}
