package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.BzscYsjglggzscCb;
import com.qianhe.mapper.BzscYsjglggzscCbMapper;
import com.qianhe.service.IBzscYsjglggzscCbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 标准手册-油水井管理岗工作手册-从Service业务层处理
 *
 * @author qianhe
 * @date 2024-10-09
 */
@Service
public class BzscYsjglggzscCbServiceImpl implements IBzscYsjglggzscCbService
{
    @Autowired
    private BzscYsjglggzscCbMapper bzscYsjglggzscCbMapper;

    /**
     * 查询标准手册-油水井管理岗工作手册-从
     *
     * @param ID 标准手册-油水井管理岗工作手册-从主键
     * @return 标准手册-油水井管理岗工作手册-从
     */
    @Override
    public BzscYsjglggzscCb selectBzscYsjglggzscCbByID(Long ID)
    {
        return bzscYsjglggzscCbMapper.selectBzscYsjglggzscCbByID(ID);
    }

    /**
     * 查询标准手册-油水井管理岗工作手册-从列表
     *
     * @param bzscYsjglggzscCb 标准手册-油水井管理岗工作手册-从
     * @return 标准手册-油水井管理岗工作手册-从
     */
    @Override
    public List<BzscYsjglggzscCb> selectBzscYsjglggzscCbList(BzscYsjglggzscCb bzscYsjglggzscCb)
    {
        return bzscYsjglggzscCbMapper.selectBzscYsjglggzscCbList(bzscYsjglggzscCb);
    }

    /**
     * 新增标准手册-油水井管理岗工作手册-从
     *
     * @param bzscYsjglggzscCb 标准手册-油水井管理岗工作手册-从
     * @return 结果
     */
    @Override
    public int insertBzscYsjglggzscCb(BzscYsjglggzscCb bzscYsjglggzscCb)
    {
        bzscYsjglggzscCb.setCreateTime(DateUtils.getNowDate());
        return bzscYsjglggzscCbMapper.insertBzscYsjglggzscCb(bzscYsjglggzscCb);
    }

    /**
     * 修改标准手册-油水井管理岗工作手册-从
     *
     * @param bzscYsjglggzscCb 标准手册-油水井管理岗工作手册-从
     * @return 结果
     */
    @Override
    public int updateBzscYsjglggzscCb(BzscYsjglggzscCb bzscYsjglggzscCb)
    {
        bzscYsjglggzscCb.setUpdateTime(DateUtils.getNowDate());
        return bzscYsjglggzscCbMapper.updateBzscYsjglggzscCb(bzscYsjglggzscCb);
    }

    /**
     * 批量删除标准手册-油水井管理岗工作手册-从
     *
     * @param IDs 需要删除的标准手册-油水井管理岗工作手册-从主键
     * @return 结果
     */
    @Override
    public int deleteBzscYsjglggzscCbByIDs(Long[] IDs)
    {
        return bzscYsjglggzscCbMapper.deleteBzscYsjglggzscCbByIDs(IDs);
    }

    /**
     * 删除标准手册-油水井管理岗工作手册-从信息
     *
     * @param ID 标准手册-油水井管理岗工作手册-从主键
     * @return 结果
     */
    @Override
    public int deleteBzscYsjglggzscCbByID(Long ID)
    {
        return bzscYsjglggzscCbMapper.deleteBzscYsjglggzscCbByID(ID);
    }
}
