package com.qianhe.service.impl;

import java.util.Iterator;
import java.util.List;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.lang.tree.TreeUtil;
import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.BaseEntity;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.stream.Collectors;

import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.domain.BzscCyglqglscCb;
import com.qianhe.mapper.BzscCyglqglscZbMapper;
import com.qianhe.domain.BzscCyglqglscZb;
import com.qianhe.service.IBzscCyglqglscZbService;

/**
 * 标准手册-采油管理区管理手册-主Service业务层处理
 *
 * @author qianhe
 * @date 2024-09-10
 */
@Service
public class BzscCyglqglscZbServiceImpl implements IBzscCyglqglscZbService
{
    @Autowired
    private BzscCyglqglscZbMapper bzscCyglqglscZbMapper;

    /**
     * 查询标准手册-采油管理区管理手册-主
     *
     * @param ID 标准手册-采油管理区管理手册-主主键
     * @return 标准手册-采油管理区管理手册-主
     */
    @Override
    public BzscCyglqglscZb selectBzscCyglqglscZbByID(Long ID)
    {
        BzscCyglqglscZb bzscCyglqglscZb = bzscCyglqglscZbMapper.selectBzscCyglqglscZbByID(ID);
        //查询从表
        List<BzscCyglqglscCb> cbList=bzscCyglqglscZbMapper.selectBzscCyglqglscCbByZbId(ID);
        bzscCyglqglscZb.setBzscCyglqglscCbList( buildDeptTree(cbList));

        return bzscCyglqglscZb;
    }

    /**
     * 查询标准手册-采油管理区管理手册-主列表
     *
     * @param bzscCyglqglscZb 标准手册-采油管理区管理手册-主
     * @return 标准手册-采油管理区管理手册-主
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<BzscCyglqglscZb> selectBzscCyglqglscZbList(BzscCyglqglscZb bzscCyglqglscZb)
    {
        return bzscCyglqglscZbMapper.selectBzscCyglqglscZbList(bzscCyglqglscZb);
    }

    /**
     * 新增标准手册-采油管理区管理手册-主
     *
     * @param bzscCyglqglscZb 标准手册-采油管理区管理手册-主
     * @return 结果
     */
    @Transactional
    @Override
    public int insertBzscCyglqglscZb(BzscCyglqglscZb bzscCyglqglscZb)
    {

        bzscCyglqglscZb.setCreateTime(DateUtils.getNowDate());
        bzscCyglqglscZb.setCreateBy(SecurityUtils.getUsername());
        int rows = bzscCyglqglscZbMapper.insertBzscCyglqglscZb(bzscCyglqglscZb);
        insertBzscCyglqglscCb(bzscCyglqglscZb);
        return rows;
    }

    /**
     * 修改标准手册-采油管理区管理手册-主
     *
     * @param bzscCyglqglscZb 标准手册-采油管理区管理手册-主
     * @return 结果
     */
    @Transactional
    @Override
    public int updateBzscCyglqglscZb(BzscCyglqglscZb bzscCyglqglscZb)
    {
        bzscCyglqglscZb.setUpdateTime(DateUtils.getNowDate());
        bzscCyglqglscZb.setUpdateBy(SecurityUtils.getUsername());
        bzscCyglqglscZbMapper.deleteBzscCyglqglscCbByZbId(bzscCyglqglscZb.getID());
        insertBzscCyglqglscCb(bzscCyglqglscZb);
        return bzscCyglqglscZbMapper.updateBzscCyglqglscZb(bzscCyglqglscZb);
    }

    /**
     * 批量删除标准手册-采油管理区管理手册-主
     *
     * @param IDs 需要删除的标准手册-采油管理区管理手册-主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteBzscCyglqglscZbByIDs(Long[] IDs)
    {
        bzscCyglqglscZbMapper.deleteBzscCyglqglscCbByZbIds(IDs);
        return bzscCyglqglscZbMapper.deleteBzscCyglqglscZbByIDs(IDs);
    }

    /**
     * 删除标准手册-采油管理区管理手册-主信息
     *
     * @param ID 标准手册-采油管理区管理手册-主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteBzscCyglqglscZbByID(Long ID)
    {
        bzscCyglqglscZbMapper.deleteBzscCyglqglscCbByZbId(ID);
        return bzscCyglqglscZbMapper.deleteBzscCyglqglscZbByID(ID);
    }

    /**
     * 新增标准手册-采油管理区管理手册-从信息
     *
     * @param bzscCyglqglscZb 标准手册-采油管理区管理手册-主对象
     */
    public void insertBzscCyglqglscCb(BzscCyglqglscZb bzscCyglqglscZb)
    {
        List<BzscCyglqglscCb> bzscCyglqglscCbList = bzscCyglqglscZb.getBzscCyglqglscCbList();
        Long ID = bzscCyglqglscZb.getID();
        if (StringUtils.isNotNull(bzscCyglqglscCbList))
        {
            List<BzscCyglqglscCb> list = new ArrayList<BzscCyglqglscCb>();
            //标题
            for (BzscCyglqglscCb bzscCyglqglscCb : bzscCyglqglscCbList)
            {
                bzscCyglqglscCb.setZbId(ID);
                bzscCyglqglscCb.setParentId(0L);
                bzscCyglqglscCb.setDeptId(bzscCyglqglscZb.getDeptId());
                bzscCyglqglscCb.setNd(bzscCyglqglscZb.getNd());
                bzscCyglqglscCb.setNr(new String(Base64.decode(bzscCyglqglscCb.getNr())));
                bzscCyglqglscZbMapper.insertBzscCyglqglscCb(bzscCyglqglscCb);
                if(StringUtils.isNotNull(bzscCyglqglscCb.getChildList())){
                    for(BzscCyglqglscCb cb1:bzscCyglqglscCb.getChildList()){
                        cb1.setZbId(ID);
                        cb1.setParentId(bzscCyglqglscCb.getID());
                        cb1.setDeptId(bzscCyglqglscZb.getDeptId());
                        cb1.setNd(bzscCyglqglscZb.getNd());
                        cb1.setNr(new String(Base64.decode(cb1.getNr())));
                        bzscCyglqglscZbMapper.insertBzscCyglqglscCb(cb1);
                        if(cb1.getChildList().size()>0){
                            for(BzscCyglqglscCb cb2:cb1.getChildList()){
                                cb2.setZbId(ID);
                                cb2.setParentId(cb1.getID());
                                cb2.setDeptId(bzscCyglqglscZb.getDeptId());
                                cb2.setNd(bzscCyglqglscZb.getNd());
                                cb2.setNr(new String(Base64.decode(cb2.getNr())));
                                bzscCyglqglscZbMapper.insertBzscCyglqglscCb(cb2);
                            }
                        }else {
                            //一级分类没有子级 则本身添加一条子级
                            BzscCyglqglscCb  cb2 =new BzscCyglqglscCb();
                            BeanUtils.copyProperties(cb1,cb2);
                            cb2.setZbId(ID);
                            cb2.setParentId(cb1.getID());
                            cb2.setDeptId(bzscCyglqglscZb.getDeptId());
                            cb2.setNd(bzscCyglqglscZb.getNd());
                            cb2.setNr(new String(Base64.decode(cb2.getNr())));
                            bzscCyglqglscZbMapper.insertBzscCyglqglscCb(cb2);
                        }
                    }
                }

//                list.add(bzscCyglqglscCb);
            }
//            if (list.size() > 0)
//            {
//                bzscCyglqglscZbMapper.batchBzscCyglqglscCb(list);
//            }
        }
    }


    public List<BzscCyglqglscCb> buildDeptTree(List<BzscCyglqglscCb> cbList)
    {
        List<BzscCyglqglscCb> returnList = new ArrayList<BzscCyglqglscCb>();
        List<Long> tempList = cbList.stream().map(BzscCyglqglscCb::getID).collect(Collectors.toList());
        for (BzscCyglqglscCb cb : cbList)
        {
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if (!tempList.contains(cb.getParentId()))
            {
                recursionFn(cbList, cb);
                returnList.add(cb);
            }
        }
        if (returnList.isEmpty())
        {
            returnList = cbList;
        }
        return returnList;
    }

    /**
     * 递归列表
     */
    private void recursionFn(List<BzscCyglqglscCb> list, BzscCyglqglscCb t)
    {
        // 得到子节点列表
        List<BzscCyglqglscCb> childList = getChildList(list, t);
        t.setChildList(childList);
        for (BzscCyglqglscCb tChild : childList)
        {
            if (hasChild(list, tChild))
            {
                recursionFn(list, tChild);
            }
        }
    }

    /**
     * 得到子节点列表
     */
    private List<BzscCyglqglscCb> getChildList(List<BzscCyglqglscCb> list, BzscCyglqglscCb t)
    {
        List<BzscCyglqglscCb> tlist = new ArrayList<BzscCyglqglscCb>();
        Iterator<BzscCyglqglscCb> it = list.iterator();
        while (it.hasNext())
        {
            BzscCyglqglscCb n = (BzscCyglqglscCb) it.next();
            if (StringUtils.isNotNull(n.getParentId()) && n.getParentId().longValue() == t.getID().longValue())
            {
                tlist.add(n);
            }
        }
        return tlist;
    }

    /**
     * 判断是否有子节点
     */
    private boolean hasChild(List<BzscCyglqglscCb> list, BzscCyglqglscCb t)
    {
        return getChildList(list, t).size() > 0;
    }
}
