package com.qianhe.mapper;

import java.util.List;
import com.qianhe.domain.SjLhsc;
import com.qianhe.domain.SjLhscWt;
import com.qianhe.domain.Vo.SjLhscVo;
import org.apache.ibatis.annotations.Param;

/**
 * 三基-例会上传Mapper接口
 * 
 * @author qianhe
 * @date 2024-07-08
 */
public interface SjLhscMapper 
{
    /**
     * 查询三基-例会上传
     * 
     * @param id 三基-例会上传主键
     * @return 三基-例会上传
     */
    public SjLhsc selectSjLhscById(Long id);

    /**
     * 查询三基-例会上传列表
     * 
     * @param sjLhsc 三基-例会上传
     * @return 三基-例会上传集合
     */
    public List<SjLhsc> selectSjLhscList(SjLhsc sjLhsc);

    /**
     * 新增三基-例会上传
     * 
     * @param sjLhsc 三基-例会上传
     * @return 结果
     */
    public int insertSjLhsc(SjLhsc sjLhsc);

    /**
     * 修改三基-例会上传
     * 
     * @param sjLhsc 三基-例会上传
     * @return 结果
     */
    public int updateSjLhsc(SjLhsc sjLhsc);

    /**
     * 删除三基-例会上传
     * 
     * @param id 三基-例会上传主键
     * @return 结果
     */
    public int deleteSjLhscById(Long id);

    /**
     * 批量删除三基-例会上传
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSjLhscByIds(Long[] ids);

    /**
     * 批量删除三基-例会上传-存在问题
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSjLhscWtByLhscIds(Long[] ids);
    
    /**
     * 批量新增三基-例会上传-存在问题
     * 
     * @param sjLhscWtList 三基-例会上传-存在问题列表
     * @return 结果
     */
    public int batchSjLhscWt(List<SjLhscWt> sjLhscWtList);
    

    /**
     * 通过三基-例会上传主键删除三基-例会上传-存在问题信息
     * 
     * @param id 三基-例会上传ID
     * @return 结果
     */
    public int deleteSjLhscWtByLhscId(Long id);

    List<SjLhscWt> selectSjLhscWtListById(Long id);


    List<SjLhscVo> tjBysfsc(SjLhscVo vo);


    List<SjLhscVo> tjByEjJjwtSl(SjLhscVo vo);

    List<SjLhsc> selectSjLhscLhgxList(SjLhsc sjLhsc);

}
