package com.qianhe.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.WdWdxxRdMapper;
import com.qianhe.domain.WdWdxxRd;
import com.qianhe.service.IWdWdxxRdService;

/**
 * 文档-热点信息Service业务层处理
 *
 * @author qianhe
 * @date 2024-09-14
 */
@Service
public class WdWdxxRdServiceImpl implements IWdWdxxRdService
{
    @Autowired
    private WdWdxxRdMapper wdWdxxRdMapper;

    /**
     * 查询文档-热点信息
     *
     * @param id 文档-热点信息主键
     * @return 文档-热点信息
     */
    @Override
    public WdWdxxRd selectWdWdxxRdById(Long id)
    {
        return wdWdxxRdMapper.selectWdWdxxRdById(id);
    }

    /**
     * 查询文档-热点信息列表
     *
     * @param wdWdxxRd 文档-热点信息
     * @return 文档-热点信息
     */
    @Override
    public List<WdWdxxRd> selectWdWdxxRdList(WdWdxxRd wdWdxxRd)
    {
        return wdWdxxRdMapper.selectWdWdxxRdList(wdWdxxRd);
    }

    /**
     * 新增文档-热点信息
     *
     * @param wdWdxxRd 文档-热点信息
     * @return 结果
     */
    @Override
    public int insertWdWdxxRd(WdWdxxRd wdWdxxRd)
    {
        return wdWdxxRdMapper.insertWdWdxxRd(wdWdxxRd);
    }

    /**
     * 修改文档-热点信息
     *
     * @param wdWdxxRd 文档-热点信息
     * @return 结果
     */
    @Override
    public int updateWdWdxxRd(WdWdxxRd wdWdxxRd)
    {
        return wdWdxxRdMapper.updateWdWdxxRd(wdWdxxRd);
    }

    /**
     * 批量删除文档-热点信息
     *
     * @param ids 需要删除的文档-热点信息主键
     * @return 结果
     */
    @Override
    public int deleteWdWdxxRdByIds(Long[] ids)
    {
        return wdWdxxRdMapper.deleteWdWdxxRdByIds(ids);
    }

    /**
     * 删除文档-热点信息信息
     *
     * @param id 文档-热点信息主键
     * @return 结果
     */
    @Override
    public int deleteWdWdxxRdById(Long id)
    {
        return wdWdxxRdMapper.deleteWdWdxxRdById(id);
    }
}
