package com.qianhe.service.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.GgFjb;
import com.qianhe.domain.SjZdsc;
import com.qianhe.service.IGgFjbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjZdscMapper;
import com.qianhe.domain.SjZdsc;
import com.qianhe.service.ISjZdscService;

/**
 * 基层三册Service业务层处理
 *
 * @author qianhe
 * @date 2025-08-04
 */
@Service
public class SjZdscServiceImpl implements ISjZdscService
{
    @Autowired
    private SjZdscMapper sjZdscMapper;
    @Autowired
    private IGgFjbService fjbService;

    /**
     * 查询基层三册
     *
     * @param id 基层三册主键
     * @return 基层三册
     */
    @Override
    public SjZdsc selectSjZdscById(Long id)
    {
        SjZdsc rt = sjZdscMapper.selectSjZdscById(id);

        //查询附件
        List<GgFjb> fjlist = fjbService.selectFj(id,"基层三册");
        Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));
        if(map.get("基层三册")!=null){
            List<GgFjb> fileData = map.get("基层三册").stream().collect(Collectors.toList());
            rt.setFileList1(fileData);
        }

        return rt;
    }

    /**
     * 查询基层三册列表
     *
     * @param sjZdsc 基层三册
     * @return 基层三册
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjZdsc> selectSjZdscList(SjZdsc sjZdsc)
    {


        List<SjZdsc> rl = sjZdscMapper.selectSjZdscList(sjZdsc);
        //查询附件
        List<GgFjb> fjlistAll = fjbService.selectFjByMk("基层三册");
        for(SjZdsc rt:rl){
            Long id = rt.getId();
            String ids = String.valueOf(id);

            List<GgFjb> fjlist = fjlistAll.stream().filter(e->e.getYWID().equals(ids)).collect(Collectors.toList());

            Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));

            if(map.get("基层三册")!=null){
                List<GgFjb> fileData = map.get("基层三册").stream().collect(Collectors.toList());
                rt.setFileList1(fileData);
            }
        }

        return rl;
    }


    /**
     * 查询基层三册列表
     *
     * @param sjZdsc 基层三册
     * @return 基层三册
     */
    @Override
    public List<SjZdsc> selectSjZdscList_gk(SjZdsc sjZdsc)
    {


        List<SjZdsc> rl = sjZdscMapper.selectSjZdscList(sjZdsc);
        //查询附件
        List<GgFjb> fjlistAll = fjbService.selectFjByMk("基层三册");
        for(SjZdsc rt:rl){
            Long id = rt.getId();
            String ids = String.valueOf(id);

            List<GgFjb> fjlist = fjlistAll.stream().filter(e->e.getYWID().equals(ids)).collect(Collectors.toList());

            Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));

            if(map.get("基层三册")!=null){
                List<GgFjb> fileData = map.get("基层三册").stream().collect(Collectors.toList());
                rt.setFileList1(fileData);
            }
        }

        return rl;
    }

    /**
     * 新增基层三册
     *
     * @param sjZdsc 基层三册
     * @return 结果
     */
    @Override
    public int insertSjZdsc(SjZdsc sjZdsc)
    {
        sjZdsc.setCreateBy(SecurityUtils.getUsername());
        sjZdsc.setCreateTime(DateUtils.getNowDate());
        return sjZdscMapper.insertSjZdsc(sjZdsc);
    }

    /**
     * 修改基层三册
     *
     * @param sjZdsc 基层三册
     * @return 结果
     */
    @Override
    public int updateSjZdsc(SjZdsc sjZdsc)
    {
        sjZdsc.setUpdateBy(SecurityUtils.getUsername());
        sjZdsc.setUpdateTime(DateUtils.getNowDate());
        return sjZdscMapper.updateSjZdsc(sjZdsc);
    }

    /**
     * 批量删除基层三册
     *
     * @param ids 需要删除的基层三册主键
     * @return 结果
     */
    @Override
    public int deleteSjZdscByIds(Long[] ids)
    {
        return sjZdscMapper.deleteSjZdscByIds(ids);
    }

    /**
     * 删除基层三册信息
     *
     * @param id 基层三册主键
     * @return 结果
     */
    @Override
    public int deleteSjZdscById(Long id)
    {
        return sjZdscMapper.deleteSjZdscById(id);
    }



    @Override
    public int pltj(SjZdsc sjZdsc)
    {
        sjZdsc.setUpdateBy(SecurityUtils.getUsername());
        sjZdsc.setUpdateTime(DateUtils.getNowDate());
        return sjZdscMapper.plxg(sjZdsc);
    }



    /**
     * 查询 共享出来的 根据 gxqx这个字段 分别取
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjZdsc> gxList(SjZdsc sjZdsc)
    {


        List<SjZdsc> rl = sjZdscMapper.gxList(sjZdsc);
        //查询附件
        List<GgFjb> fjlistAll = fjbService.selectFjByMk("基层三册");
        for(SjZdsc rt:rl){
            Long id = rt.getId();
            String ids = String.valueOf(id);

            List<GgFjb> fjlist = fjlistAll.stream().filter(e->e.getYWID().equals(ids)).collect(Collectors.toList());

            Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));

            if(map.get("基层三册")!=null){
                List<GgFjb> fileData = map.get("基层三册").stream().collect(Collectors.toList());
                rt.setFileList1(fileData);
            }
        }

        return rl;
    }
    /**
     * 查询 共享出来的 根据 gxqx这个字段 分别取
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjZdsc> gxgkList(SjZdsc sjZdsc)
    {


        List<SjZdsc> rl = sjZdscMapper.gxgkList(sjZdsc);
        //查询附件
        List<GgFjb> fjlistAll = fjbService.selectFjByMk("基层三册");
        for(SjZdsc rt:rl){
            Long id = rt.getId();
            String ids = String.valueOf(id);

            List<GgFjb> fjlist = fjlistAll.stream().filter(e->e.getYWID().equals(ids)).collect(Collectors.toList());

            Map<String, List<GgFjb>> map = fjlist.stream().collect(Collectors.groupingBy(GgFjb::getFJLX));

            if(map.get("基层三册")!=null){
                List<GgFjb> fileData = map.get("基层三册").stream().collect(Collectors.toList());
                rt.setFileList1(fileData);
            }
        }

        return rl;
    }

}
