package com.qianhe.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.SjZdbfZsdwkhpj;
import com.qianhe.domain.SjZdbfZsdwkhpjZb;
import com.qianhe.mapper.SjZdbfZsdwkhpjZbMapper;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjZdbfZsdwkhpjfjxMapper;
import com.qianhe.domain.SjZdbfZsdwkhpjfjx;
import com.qianhe.service.ISjZdbfZsdwkhpjfjxService;

/**
 * 指导帮扶-直属单位考核评价否决项Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Service
public class SjZdbfZsdwkhpjfjxServiceImpl implements ISjZdbfZsdwkhpjfjxService
{
    @Autowired
    private SjZdbfZsdwkhpjfjxMapper sjZdbfZsdwkhpjfjxMapper;

    @Autowired
    private SjZdbfZsdwkhpjZbMapper sjZdbfZsdwkhpjZbMapper;
    /**
     * 查询指导帮扶-直属单位考核评价否决项
     *
     * @param id 指导帮扶-直属单位考核评价否决项主键
     * @return 指导帮扶-直属单位考核评价否决项
     */
    @Override
    public SjZdbfZsdwkhpjfjx selectSjZdbfZsdwkhpjfjxById(Long id)
    {
        return sjZdbfZsdwkhpjfjxMapper.selectSjZdbfZsdwkhpjfjxById(id);
    }

    /**
     * 查询指导帮扶-直属单位考核评价否决项列表
     *
     * @param sjZdbfZsdwkhpjfjx 指导帮扶-直属单位考核评价否决项
     * @return 指导帮扶-直属单位考核评价否决项
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjZdbfZsdwkhpjfjx> selectSjZdbfZsdwkhpjfjxList(SjZdbfZsdwkhpjfjx sjZdbfZsdwkhpjfjx)
    {
        return sjZdbfZsdwkhpjfjxMapper.selectSjZdbfZsdwkhpjfjxList(sjZdbfZsdwkhpjfjx);
    }

    /**
     * 新增指导帮扶-直属单位考核评价否决项
     *
     * @param sjZdbfZsdwkhpjfjx 指导帮扶-直属单位考核评价否决项
     * @return 结果
     */
    @Override
    public int insertSjZdbfZsdwkhpjfjx(SjZdbfZsdwkhpjfjx sjZdbfZsdwkhpjfjx)
    {
        sjZdbfZsdwkhpjfjx.setCreateTime(DateUtils.getNowDate());
        return sjZdbfZsdwkhpjfjxMapper.insertSjZdbfZsdwkhpjfjx(sjZdbfZsdwkhpjfjx);
    }

    /**
     * 修改指导帮扶-直属单位考核评价否决项
     *
     * @param sjZdbfZsdwkhpjfjx 指导帮扶-直属单位考核评价否决项
     * @return 结果
     */
    @Override
    public int updateSjZdbfZsdwkhpjfjx(SjZdbfZsdwkhpjfjx sjZdbfZsdwkhpjfjx)
    {
        sjZdbfZsdwkhpjfjx.setUpdateTime(DateUtils.getNowDate());
        return sjZdbfZsdwkhpjfjxMapper.updateSjZdbfZsdwkhpjfjx(sjZdbfZsdwkhpjfjx);
    }

    /**
     * 批量删除指导帮扶-直属单位考核评价否决项
     *
     * @param ids 需要删除的指导帮扶-直属单位考核评价否决项主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwkhpjfjxByIds(Long[] ids)
    {
        return sjZdbfZsdwkhpjfjxMapper.deleteSjZdbfZsdwkhpjfjxByIds(ids);
    }

    /**
     * 删除指导帮扶-直属单位考核评价否决项信息
     *
     * @param id 指导帮扶-直属单位考核评价否决项主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwkhpjfjxById(Long id)
    {
        return sjZdbfZsdwkhpjfjxMapper.deleteSjZdbfZsdwkhpjfjxById(id);
    }

    @Override
    public int batchSave(List<SjZdbfZsdwkhpjfjx> fjxList) {
        return sjZdbfZsdwkhpjfjxMapper.batchSave(fjxList);
    }

    @Override
    public int pledit(List<SjZdbfZsdwkhpjfjx> list) {
        SjZdbfZsdwkhpjfjx sjZdbfZsdwkhpjfjx = list.get(0);
        SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb = sjZdbfZsdwkhpjZbMapper.selectSjZdbfZsdwkhpjZbById(sjZdbfZsdwkhpjfjx.getZbId());
        List<SjZdbfZsdwkhpjfjx> collect = list.stream().filter(item -> "是".equals(item.getSffs())).collect(Collectors.toList());
        sjZdbfZsdwkhpjZb.setSffjxs(new BigDecimal(collect.size()));
        sjZdbfZsdwkhpjZbMapper.updateSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb);
        return sjZdbfZsdwkhpjfjxMapper.pledit(list);
    }
}
