package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.SjZdbfZsdwwtcj;
import com.qianhe.mapper.SjZdbfJcdwwtcjMapper;

import com.qianhe.service.ISjZdbfJcdwwtcjService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 指导帮扶-基层单位问题采集Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-23
 */
@Service
public class SjZdbfJcdwwtcjServiceImpl implements ISjZdbfJcdwwtcjService
{
    @Autowired
    private SjZdbfJcdwwtcjMapper sjZdbfJcdwwtcjMapper;

    /**
     * 查询指导帮扶-基层单位问题采集
     *
     * @param id 指导帮扶-基层单位问题采集主键
     * @return 指导帮扶-基层单位问题采集
     */
    @Override
    public SjZdbfZsdwwtcj selectSjZdbfZsdwwtcjById(Long id)
    {
        SjZdbfZsdwwtcj zsdwwtcj = sjZdbfJcdwwtcjMapper.selectSjZdbfZsdwwtcjById(id);
        return zsdwwtcj;
    }

    /**
     * 查询指导帮扶-基层单位问题采集列表
     *
     * @param sjZdbfZsdwwtcj 指导帮扶-基层单位问题采集
     * @return 指导帮扶-基层单位问题采集
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjZdbfZsdwwtcj> selectSjZdbfZsdwwtcjList(SjZdbfZsdwwtcj sjZdbfZsdwwtcj)
    {
        return sjZdbfJcdwwtcjMapper.selectSjZdbfZsdwwtcjList(sjZdbfZsdwwtcj);
    }

    /**
     * 新增指导帮扶-基层单位问题采集
     *
     * @param sjZdbfZsdwwtcj 指导帮扶-基层单位问题采集
     * @return 结果
     */
    @Override
    public int insertSjZdbfZsdwwtcj(SjZdbfZsdwwtcj sjZdbfZsdwwtcj)
    {
        sjZdbfZsdwwtcj.setCreateTime(DateUtils.getNowDate());
        sjZdbfZsdwwtcj.setCreateBy(SecurityUtils.getUsername());
        return sjZdbfJcdwwtcjMapper.insertSjZdbfZsdwwtcj(sjZdbfZsdwwtcj);
    }

    /**
     * 修改指导帮扶-基层单位问题采集
     *
     * @param sjZdbfZsdwwtcj 指导帮扶-基层单位问题采集
     * @return 结果
     */
    @Override
    public int updateSjZdbfZsdwwtcj(SjZdbfZsdwwtcj sjZdbfZsdwwtcj)
    {
        sjZdbfZsdwwtcj.setUpdateTime(DateUtils.getNowDate());
        sjZdbfZsdwwtcj.setUpdateBy(SecurityUtils.getUsername());
        return sjZdbfJcdwwtcjMapper.updateSjZdbfZsdwwtcj(sjZdbfZsdwwtcj);
    }

    /**
     * 批量删除指导帮扶-基层单位问题采集
     *
     * @param ids 需要删除的指导帮扶-基层单位问题采集主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwwtcjByIds(Long[] ids)
    {
        return sjZdbfJcdwwtcjMapper.deleteSjZdbfZsdwwtcjByIds(ids);
    }

    /**
     * 删除指导帮扶-基层单位问题采集信息
     *
     * @param id 指导帮扶-基层单位问题采集主键
     * @return 结果
     */
    @Override
    public int deleteSjZdbfZsdwwtcjById(Long id)
    {
        return sjZdbfJcdwwtcjMapper.deleteSjZdbfZsdwwtcjById(id);
    }

    @Override
    public int batchSave(List<SjZdbfZsdwwtcj> list) {
        return sjZdbfJcdwwtcjMapper.batchSave(list);
    }
}
