package com.qianhe.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.Vo.JcdwxxVo;
import com.qianhe.system.domain.SysDeptCb;
import com.qianhe.system.mapper.SysDeptMapper;
import com.qianhe.system.service.ISysDeptCbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjBzxxMapper;
import com.qianhe.domain.SjBzxx;
import com.qianhe.service.ISjBzxxService;

/**
 * 班组信息Service业务层处理
 *
 * @author qianhe
 * @date 2025-08-04
 */
@Service
public class SjBzxxServiceImpl implements ISjBzxxService
{
    @Autowired
    private SjBzxxMapper sjBzxxMapper;
    @Autowired
    private SysDeptMapper sysDeptMapper;
    @Autowired
    private ISysDeptCbService sysDeptCbService;

    /**
     * 查询班组信息
     *
     * @param id 班组信息主键
     * @return 班组信息
     */
    @Override
    public SjBzxx selectSjBzxxById(Long id)
    {
        return sjBzxxMapper.selectSjBzxxById(id);
    }

    /**
     * 查询班组信息列表
     *
     * @param sjBzxx 班组信息
     * @return 班组信息
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjBzxx> selectSjBzxxList(SjBzxx sjBzxx)
    {
        return sjBzxxMapper.selectSjBzxxList(sjBzxx);
    }

    /**
     * 新增班组信息
     *
     * @param sjBzxx 班组信息
     * @return 结果
     */
    @Override
    public int insertSjBzxx(SjBzxx sjBzxx)
    {
        sjBzxx.setCreateBy(SecurityUtils.getUsername());
        sjBzxx.setCreateTime(DateUtils.getNowDate());
        return sjBzxxMapper.insertSjBzxx(sjBzxx);
    }

    /**
     * 修改班组信息
     *
     * @param sjBzxx 班组信息
     * @return 结果
     */
    @Override
    public int updateSjBzxx(SjBzxx sjBzxx)
    {
        sjBzxx.setUpdateBy(SecurityUtils.getUsername());
        sjBzxx.setUpdateTime(DateUtils.getNowDate());
        return sjBzxxMapper.updateSjBzxx(sjBzxx);
    }

    /**
     * 批量删除班组信息
     *
     * @param ids 需要删除的班组信息主键
     * @return 结果
     */
    @Override
    public int deleteSjBzxxByIds(Long[] ids)
    {
        return sjBzxxMapper.deleteSjBzxxByIds(ids);
    }

    /**
     * 删除班组信息信息
     *
     * @param id 班组信息主键
     * @return 结果
     */
    @Override
    public int deleteSjBzxxById(Long id)
    {
        return sjBzxxMapper.deleteSjBzxxById(id);
    }





    @Override
    @DataScope(deptAlias = "d")
    public SjBzxx selectBzxxTj(SjBzxx sjBzxx)
    {
        return sjBzxxMapper.selectBzxxTj(sjBzxx);
    }
    @Override
    public int pltj(SjBzxx sjBzxx)
    {
        sjBzxx.setUpdateBy(SecurityUtils.getUsername());
        sjBzxx.setUpdateTime(DateUtils.getNowDate());
        return sjBzxxMapper.plxg(sjBzxx);
    }

    @Override
    @DataScope(deptAlias = "a")
    public List<JcdwxxVo> jcdwtjList(JcdwxxVo jcdwxxVo) {
        if(jcdwxxVo.getDeptId()!=null){
            SysDept dept = sysDeptMapper.selectDeptById(jcdwxxVo.getDeptId());
            if(dept!=null){
                if(dept.getDwjb().equals("3")){
                    jcdwxxVo.setZsdwid(dept.getDeptId());
                }else if(dept.getDwjb().equals("4")){
                    jcdwxxVo.setJcdwid(dept.getDeptId());
                }
            }

        }
        List<JcdwxxVo> list =sjBzxxMapper.jcdwtjList(jcdwxxVo);
        return list;
    }


    /** 查询统计 单位班组人数统计信息 */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjBzxx> dwbzrstjList(SjBzxx sjBzxx)
    {
        Long get_deptId = sjBzxx.getDeptId();
        String get_zsdwfl = sjBzxx.getZsdwfl();
        String get_bzlx = sjBzxx.getBzlx();

        //直属单位
        SysDept s_in = new SysDept();
        s_in.setDeptId(get_deptId);
        s_in.setDeptYwfl(get_zsdwfl);
        s_in.setDwjb("3");
        List<SysDept> zss = sysDeptMapper.selectDeptList(s_in);
        //基层单位
        SysDept s_in2 = new SysDept();
        s_in2.setDwjb("4");
        List<SysDept> jcs = sysDeptMapper.selectDeptList(s_in2);

        //班组
        SjBzxx bz_in = new SjBzxx();
        bz_in.setBzlx(get_bzlx);
        List<SjBzxx> bzs = sjBzxxMapper.selectSjBzxxList(bz_in);

        List<SysDeptCb> cbs = sysDeptCbService.selectSysDeptCbList(new SysDeptCb());//单位从表

        //List<SysDept> zss = deptList.stream().filter(e->"3".equals(e.getDwjb())).collect(Collectors.toList());//直属单位
        //List<SysDept> jcs = deptList.stream().filter(e->"4".equals(e.getDwjb())).collect(Collectors.toList());//基层单位

        List<SjBzxx> rts = new ArrayList<>();//返回结果
        for(int i = 0; i < zss.size(); i++){//循环直属单位
            SysDept zs = zss.get(i);

            Long zsdwId = zs.getDeptId();
            String zsdw = zs.getDeptName();
            //直属单位的从表
            SysDeptCb zsdwcb = cbs.stream().filter(e->String.valueOf(zsdwId).equals(e.getDeptId())).findAny().orElse(new SysDeptCb());
            String zsdwfl = zsdwcb.getDwlx();

            //求和 中间变量
            long tmp_bzsl1 = 0;//管理类班组（室中心）数量
            long tmp_bzsl2 = 0;//一线生产班组数量
            long tmp_bzsl3 = 0;//研究类班组（室中心）数量
            long tmp_bzsl4 = 0;//后勤服务类班组数量
            long tmp_bzsl5 = 0;//其他
            long tmp_rs = 0;//全部用工人数
            long tmp_ygrsxj = 0;//用工人数小计

            //当前直属单位下的 基层单位
            List<SysDept> bdwjcs = jcs.stream().filter(e->zsdwId.equals(e.getParentId())).collect(Collectors.toList());
            for(int j = 0; j < bdwjcs.size(); j++){//循环直属单位下基层单位
                SysDept jc = bdwjcs.get(j);

                Long jcdwId = jc.getDeptId();
                String jcdw = jc.getDeptName();
                //基层单位的从表
                SysDeptCb jcdwcb = cbs.stream().filter(e->String.valueOf(jcdwId).equals(e.getDeptId())).findAny().orElse(new SysDeptCb());
                String jcdwfl = jcdwcb.getDwlx();
                Long jcdwrs = jcdwcb.getJcrysl();//用工人数小计
                if(jcdwrs == null) {
                    jcdwrs = 0L;
                }

                //查询基层单位 班组
                List<SjBzxx> bdwbzs = bzs.stream().filter(e->jcdwId.equals(e.getDeptId())).collect(Collectors.toList());
                if(bdwbzs.size() > 0){
                    //有下属班组 用工人数小计为求其rs的和
                    jcdwrs = bdwbzs.stream().filter(bzxx -> bzxx != null && bzxx.getRs() != null && !bzxx.getRs().trim().isEmpty())
                            .mapToLong(bzxx -> {
                                try {
                                    return Long.parseLong(bzxx.getRs().trim());
                                } catch (NumberFormatException e) {
                                    return 0L;
                                }
                            }).sum();

                    long count1 = bdwbzs.stream().filter(bzxx -> "管理类班组（室中心）".equals(bzxx.getBzlx())).count();
                    long count2 = bdwbzs.stream().filter(bzxx -> "一线生产班组".equals(bzxx.getBzlx())).count();
                    long count3 = bdwbzs.stream().filter(bzxx -> "研究类班组（室中心）".equals(bzxx.getBzlx())).count();
                    long count4 = bdwbzs.stream().filter(bzxx -> "后勤服务类班组".equals(bzxx.getBzlx())).count();
                    long count5 = bdwbzs.stream().filter(bzxx -> "其他".equals(bzxx.getBzlx())).count();

                    String bzsl1 = String.valueOf(count1);//管理类班组（室中心）数量
                    String bzsl2 = String.valueOf(count2);//一线生产班组数量
                    String bzsl3 = String.valueOf(count3);//研究类班组（室中心）数量
                    String bzsl4 = String.valueOf(count4);//后勤服务类班组数量
                    String bzsl5 = String.valueOf(count5);//其他

                    tmp_bzsl1 += count1;//累加
                    tmp_bzsl2 += count2;
                    tmp_bzsl3 += count3;
                    tmp_bzsl4 += count4;
                    tmp_bzsl5 += count5;
                    tmp_ygrsxj += jcdwrs;//累加用工人数小计

                    //有下属班组 就循环
                    for(int k = 0; k < bdwbzs.size(); k++) {//循环基层单位下班组
                        SjBzxx bz = bdwbzs.get(k);

                        long rs = StringUtils.isNotEmpty(bz.getRs())? Long.parseLong(bz.getRs()):0L;
                        tmp_rs += rs;//累加全部用工人数

                        SjBzxx rt = new SjBzxx();
                        rt.setZsdw(zsdw);
                        rt.setZsdwfl(zsdwfl);
                        rt.setJcdw(jcdw);
                        rt.setJcdwfl(jcdwfl);
                        rt.setBzmc(bz.getBzmc());
                        rt.setBzlx(bz.getBzlx());
                        rt.setRs(bz.getRs());

                        rt.setBzsl1(bzsl1);
                        rt.setBzsl2(bzsl2);
                        rt.setBzsl3(bzsl3);
                        rt.setBzsl4(bzsl4);
                        rt.setBzsl5(bzsl5);
                        rt.setYgrsxj(String.valueOf(jcdwrs));

                        rts.add(rt);
                    }
                }
                //没有下属班组 就基层一条数据
                if(bdwbzs.size() <= 0){

                    SjBzxx rt = new SjBzxx();
                    rt.setZsdw(zsdw);
                    rt.setZsdwfl(zsdwfl);
                    rt.setJcdw(jcdw);
                    rt.setJcdwfl(jcdwfl);

                    rt.setRs(jcdwrs == null? "":String.valueOf(jcdwrs));
                    rt.setYgrsxj(jcdwrs == null? "":String.valueOf(jcdwrs));

                    tmp_rs += jcdwrs;//累加全部用工人数
                    tmp_ygrsxj += jcdwrs;//累加用工人数小计

                    rts.add(rt);
                }
            }

            //直属单位合计
            SjBzxx rt = new SjBzxx();
            rt.setZsdw(zsdw);
            rt.setZsdwfl(zsdwfl);
            rt.setBzlx("合计");

            rt.setBzsl1(String.valueOf(tmp_bzsl1));
            rt.setBzsl2(String.valueOf(tmp_bzsl2));
            rt.setBzsl3(String.valueOf(tmp_bzsl3));
            rt.setBzsl4(String.valueOf(tmp_bzsl4));
            rt.setBzsl5(String.valueOf(tmp_bzsl5));
            rt.setRs(String.valueOf(tmp_rs));
            rt.setYgrsxj(String.valueOf(tmp_ygrsxj));

            rts.add(rt);
        }
        return rts;
    }
}
