package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.WdLxwh;
import com.qianhe.service.IWdLxwhService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 文档-类型维护Controller
 *
 * @author qianhe
 * @date 2024-02-28
 */
@RestController
@RequestMapping("/system/WdLxwh")
public class WdLxwhController extends BaseController
{
    @Autowired
    private IWdLxwhService wdLxwhService;

    /**
     * 查询文档-类型维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:WdLxwh:list')")
    @GetMapping("/list")
    public TableDataInfo list(WdLxwh wdLxwh)
    {
        startPage();
        List<WdLxwh> list = wdLxwhService.selectWdLxwhList(wdLxwh);
        return getDataTable(list);
    }

    /**
     * 导出文档-类型维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:WdLxwh:export')")
    @Log(title = "文档-类型维护", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WdLxwh wdLxwh)
    {
        List<WdLxwh> list = wdLxwhService.selectWdLxwhList(wdLxwh);
        ExcelUtil<WdLxwh> util = new ExcelUtil<WdLxwh>(WdLxwh.class);
        util.exportExcel(response, list, "文档-类型维护数据");
    }

    /**
     * 获取文档-类型维护详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:WdLxwh:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(wdLxwhService.selectWdLxwhById(id));
    }

    /**
     * 新增文档-类型维护
     */
    @PreAuthorize("@ss.hasPermi('system:WdLxwh:add')")
    @Log(title = "文档-类型维护", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody WdLxwh wdLxwh)
    {
        return toAjax(wdLxwhService.insertWdLxwh(wdLxwh));
    }

    /**
     * 修改文档-类型维护
     */
    @PreAuthorize("@ss.hasPermi('system:WdLxwh:edit')")
    @Log(title = "文档-类型维护", businessType = BusinessType.UPDATE)
    @PostMapping("/edit")
    public AjaxResult edit(@RequestBody WdLxwh wdLxwh)
    {
        return toAjax(wdLxwhService.updateWdLxwh(wdLxwh));
    }

    /**
     * 删除文档-类型维护
     */
    @PreAuthorize("@ss.hasPermi('system:WdLxwh:remove')")
    @Log(title = "文档-类型维护", businessType = BusinessType.DELETE)
	@PostMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(wdLxwhService.deleteWdLxwhByIds(ids));
    }
}
