package com.qianhe.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.*;
import com.qianhe.domain.Vo.SjfybpVo;
import com.qianhe.mapper.SjFybpWhMapper;
import com.qianhe.mapper.WdWdxxMapper;
import com.qianhe.system.domain.SysDeptCb;
import com.qianhe.system.mapper.SysDeptCbMapper;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;

import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.mapper.SjFybpMapper;
import com.qianhe.service.ISjFybpService;

/**
 * 三基-费用报批Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-05
 */
@Service
public class SjFybpServiceImpl implements ISjFybpService
{
    @Autowired
    private SjFybpMapper sjFybpMapper;

    @Autowired
    private SjFybpWhMapper sjFybpWhMapper;
    @Autowired
    private WdWdxxMapper wdWdxxMapper;

    @Autowired
    private SysDeptCbMapper sysDeptCbMapper;

    /**
     * 查询三基-费用报批
     *
     * @param id 三基-费用报批主键
     * @return 三基-费用报批
     */
    @Override
    public SjFybp selectSjFybpById(Long id)
    {
        SjFybp sjFybp = sjFybpMapper.selectSjFybpById(id);
        //查询费用维护
        SjFybpWh sjFybpWh=new SjFybpWh();
        sjFybpWh.setFybpId(id);
        List<SjFybpWh> sjFybpWhs = sjFybpWhMapper.selectSjFybpWhList(sjFybpWh);
        sjFybp.setSjFybpWhList(sjFybpWhs);
        //查询文档
        WdWdxx wdWdxx=new WdWdxx();
        wdWdxx.setGlId(sjFybp.getId().toString());
        wdWdxx.setMkmc("费用报批");
        wdWdxx.setFjlx("费用上报");
        List<WdWdxx> wdWdxxes = wdWdxxMapper.selectWdWdxxList(wdWdxx);
        sjFybp.setFileList(wdWdxxes);
        return sjFybp;
    }

    /**
     * 查询三基-费用报批列表
     *
     * @param sjFybp 三基-费用报批
     * @return 三基-费用报批
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjFybp> selectSjFybpList(SjFybp sjFybp)
    {
        return sjFybpMapper.selectSjFybpList(sjFybp);
    }

    /**
     * 新增三基-费用报批
     *
     * @param sjFybp 三基-费用报批
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjFybp(SjFybp sjFybp)
    {
        sjFybp.setCreateTime(DateUtils.getNowDate());
        sjFybp.setCreateBy(SecurityUtils.getUsername());
        int rows = sjFybpMapper.insertSjFybp(sjFybp);
        //保存文件
        if(StringUtils.isNotEmpty(sjFybp.getFileList())){
            if(sjFybp.getFileList().size()>0){
                sjFybp.getFileList().forEach(file->{
                    file.setGlId(sjFybp.getId().toString());
                    file.setMkmc("费用报批");
                    file.setFjlx("费用上报");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }


        return rows;
    }

    /**
     * 修改三基-费用报批
     *
     * @param sjFybp 三基-费用报批
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjFybp(SjFybp sjFybp)
    {
        //先删除文件
        wdWdxxMapper.deleteWdWdxxByGlIdAndMkmc(sjFybp.getId()+"","费用报批");
        //保存文件
        if(StringUtils.isNotEmpty(sjFybp.getFileList())){
            if(sjFybp.getFileList().size()>0){
                sjFybp.getFileList().forEach(file->{
                    file.setGlId(sjFybp.getId().toString());
                    file.setMkmc("费用报批");
                    file.setFjlx("费用上报");
                    file.setLrr(SecurityUtils.getUsername());
                    wdWdxxMapper.insertWdWdxx(file);
                });
            }
        }
        sjFybp.setUpdateTime(DateUtils.getNowDate());
        sjFybp.setUpdateBy(SecurityUtils.getUsername());
        return sjFybpMapper.updateSjFybp(sjFybp);
    }

    /**
     * 批量删除三基-费用报批
     *
     * @param ids 需要删除的三基-费用报批主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjFybpByIds(Long[] ids)
    {
        sjFybpMapper.deleteSjFybpWhByFybpIds(ids);
        return sjFybpMapper.deleteSjFybpByIds(ids);
    }

    /**
     * 删除三基-费用报批信息
     *
     * @param id 三基-费用报批主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjFybpById(Long id)
    {
        sjFybpMapper.deleteSjFybpWhByFybpId(id);
        return sjFybpMapper.deleteSjFybpById(id);
    }

    @Override
    public int tj(SjFybp sjFybp) {
       if("待审批".equals(sjFybp.getZt())){
           sjFybp.setTjr(SecurityUtils.getUsername());
           sjFybp.setTjrq(DateUtils.dateTimeNow("yyyy-MM-dd HH:mm:ss"));
       }else if("已批复".equals(sjFybp.getZt()) || "已驳回" .equals(sjFybp.getZt())) {
           sjFybp.setSpr(SecurityUtils.getUsername());
           sjFybp.setSprq(DateUtils.dateTimeNow("yyyy-MM-dd HH:mm:ss"));
       }
        return sjFybpMapper.updateSjFybp(sjFybp);
    }

    @Override
    public int fywh(SjFybp sjFybp) {
        sjFybpMapper.deleteSjFybpWhByFybpId(sjFybp.getId());
        if(StringUtils.isNotEmpty(sjFybp.getSjFybpWhList())){
            //统计已结算金额
            BigDecimal reduce = sjFybp.getSjFybpWhList().stream().map(SjFybpWh::getSyje).reduce(BigDecimal.ZERO, BigDecimal::add);
            sjFybp.setYsyje(reduce);
            sjFybpMapper.updateSjFybp(sjFybp);
        }
        insertSjFybpWh(sjFybp);
        return 1;
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjfybpVo> tjtbByDept(SjFybp sjFybp) {
        return sjFybpMapper.tjtbByDept(sjFybp);
    }

    @Override
    @DataScope(deptAlias = "d")
    public  List<SjfybpVo> tjtbByfylx(SjFybp sjFybp) {
        List<SjfybpVo> voList = sjFybpMapper.tjtbByfylx(sjFybp);
        //计算总数
        SjfybpVo vo =new SjfybpVo();
        vo.setFylxmc("总");
        vo.setFylx("总");
        int sum = voList.stream().mapToInt(SjfybpVo::getZsl).sum();
        vo.setZsl(sum);
        BigDecimal xmje = voList.stream().map(SjfybpVo::getXmje).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setXmje(xmje);
        BigDecimal yjyje = voList.stream().map(SjfybpVo::getYsyje).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setYsyje(yjyje);
        voList.add(0, vo);
        return voList;
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjFybp> getFygz(SjFybp sjFybp) {
        return sjFybpMapper.getFygz(sjFybp);
    }

    @Override
    public SjFybp getFygzById(Long id) {
        SjFybp sjFybp = sjFybpMapper.getFygzById(id);
        //查询费用维护
        SjFybpWh sjFybpWh=new SjFybpWh();
        sjFybpWh.setFybpId(id);
        List<SjFybpWh> sjFybpWhs = sjFybpWhMapper.selectSjFybpWhList(sjFybpWh);
        sjFybp.setSjFybpWhList(sjFybpWhs);
        return sjFybp;
    }

    @Override
    @DataScope(deptAlias = "d")
    public List<SjFybp> selectSjFybpCtList(SjFybp sjFybp) {
        return sjFybpMapper.selectSjFybpCtList(sjFybp);
    }

    /**
     * 新增三基-费用维护信息
     *
     * @param sjFybp 三基-费用报批对象
     */
    public void insertSjFybpWh(SjFybp sjFybp)
    {
        List<SjFybpWh> sjFybpWhList = sjFybp.getSjFybpWhList();
        Long id = sjFybp.getId();
        if (StringUtils.isNotNull(sjFybpWhList))
        {
            List<SjFybpWh> list = new ArrayList<SjFybpWh>();
            for (SjFybpWh sjFybpWh : sjFybpWhList)
            {
                sjFybpWh.setFybpId(id);
                list.add(sjFybpWh);
            }
            if (list.size() > 0)
            {
                sjFybpMapper.batchSjFybpWh(list);
            }
        }
    }



    /** 直属单位三基建设费用统计表 */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjfybpVo> zsdwNdfytj(SjFybp sjFybp) {
        List<SjfybpVo> vs = sjFybpMapper.tjtbByDept(sjFybp);
        List<SjFybpWh> whs = sjFybpWhMapper.selectSjFybpWhList(new SjFybpWh());//查询所有费用维护表数据
        //return sjFybpMapper.selectSjFybpCtList(sjFybp);

        //季度
        String[] jddms = {"第一季度","第二季度","第三季度","第四季度","合计"};
        String[] jdmcs = {"一季度","二季度","三季度","四季度","合计"};

        List<SjfybpVo> rtnList = new ArrayList<>();
        for(SjfybpVo v:vs){
            String zbid = v.getId();//主表id
            String fyrq = v.getFyrq();//日期 年
            //根据单位 年度 查询参考标准  (可选参数 fyje
            SjFybpZb ckbz_qry = new SjFybpZb();
            ckbz_qry.setFyrq(v.getFyrq());
            ckbz_qry.setDeptId(v.getDeptId());
            SjFybpZb ckbz = getDeptCkbz(ckbz_qry);

            for(int i=0; i < jddms.length; i++){
                String jddm = jddms[i];
                String jdmc = jdmcs[i];

                SjfybpVo r = new SjfybpVo();
                BeanUtils.copyProperties(v, r);

                r.setJd(jdmc);
                r.setAbztqzded(ckbz.getJsbzSum());


                //三基标杆打造
                List<SjFybpWh> whs1 = whs.stream().filter(e->zbid.equals(e.getZbId()) && fyrq.equals(e.getSyrq())
                        && jddm.equals(e.getYl1()) && "三基标杆打造".equals(e.getFylx())).collect(Collectors.toList());
                String sum1 = whs1.stream().map(SjFybpWh::getSyje).filter(Objects::nonNull)
                        .reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
                List<String> zcmx1 = whs1.stream().map(SjFybpWh::getRemark).collect(Collectors.toList());
                r.setXmzc1(sum1);
                r.setXmzcmx1(String.join(";",zcmx1));
                if("合计".equals(jdmc)){
                    r.setXmzcmx1(null);
                }

                //三个最强全员练兵
                List<SjFybpWh> whs2 = whs.stream().filter(e->zbid.equals(e.getZbId()) && fyrq.equals(e.getSyrq())
                        && jddm.equals(e.getYl1()) && "三个最强全员练兵".equals(e.getFylx())).collect(Collectors.toList());
                String sum2 = whs2.stream().map(SjFybpWh::getSyje).filter(Objects::nonNull)
                        .reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
                List<String> zcmx2 = whs2.stream().map(SjFybpWh::getRemark).collect(Collectors.toList());
                r.setXmzc2(sum2);
                r.setXmzcmx2(String.join(";",zcmx2));
                if("合计".equals(jdmc)){
                    r.setXmzcmx2(null);
                }

                //三标建设5S管理
                List<SjFybpWh> whs3 = whs.stream().filter(e->zbid.equals(e.getZbId()) && fyrq.equals(e.getSyrq())
                        && jddm.equals(e.getYl1()) && "三标建设5S管理".equals(e.getFylx())).collect(Collectors.toList());
                String sum3 = whs3.stream().map(SjFybpWh::getSyje).filter(Objects::nonNull)
                        .reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
                List<String> zcmx3 = whs3.stream().map(SjFybpWh::getRemark).collect(Collectors.toList());
                r.setXmzc3(sum3);
                r.setXmzcmx3(String.join(";",zcmx3));
                if("合计".equals(jdmc)){
                    r.setXmzcmx3(null);
                }

                //基层班站建设
                List<SjFybpWh> whs4 = whs.stream().filter(e->zbid.equals(e.getZbId()) && fyrq.equals(e.getSyrq())
                        && jddm.equals(e.getYl1()) && "基层班站建设".equals(e.getFylx())).collect(Collectors.toList());
                String sum4 = whs4.stream().map(SjFybpWh::getSyje).filter(Objects::nonNull)
                        .reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
                List<String> zcmx4 = whs4.stream().map(SjFybpWh::getRemark).collect(Collectors.toList());
                r.setXmzc4(sum4);
                r.setXmzcmx4(String.join(";",zcmx4));
                if("合计".equals(jdmc)){
                    r.setXmzcmx4(null);
                }

                //其他
                List<SjFybpWh> whs5 = whs.stream().filter(e->zbid.equals(e.getZbId()) && fyrq.equals(e.getSyrq())
                        && jddm.equals(e.getYl1()) && "其他".equals(e.getFylx())).collect(Collectors.toList());
                String sum5 = whs5.stream().map(SjFybpWh::getSyje).filter(Objects::nonNull)
                        .reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP).toString();
                List<String> zcmx5 = whs5.stream().map(SjFybpWh::getRemark).collect(Collectors.toList());
                r.setXmzc5(sum5);
                r.setXmzcmx5(String.join(";",zcmx5));
                if("合计".equals(jdmc)){
                    r.setXmzcmx5(null);
                }

                rtnList.add(r);
            }

        }


        return rtnList;
    }

    //根据单位 年度 查询参考标准  (可选参数 fyje
    public SjFybpZb getDeptCkbz(SjFybpZb sjFybpZb){

        SysDeptCb sysDeptCb = new SysDeptCb();
        sysDeptCb.setNd(sjFybpZb.getFyrq());
        sysDeptCb.setDeptId(sjFybpZb.getDeptId());
        SysDeptCb deptCb = sysDeptCbMapper.getInfoBydeptId(sysDeptCb);
        if(deptCb==null){
            sjFybpZb.setJl("该单位基础信息未维护，请到部门管理中进行设置！");
        }else {
            if(StringUtils.isNotEmpty( deptCb.getDwlx() )){
                String dwlx = deptCb.getDwlx();
                BigDecimal jyqlhjysr = deptCb.getJyqlhjysr();//万吨 换算成吨
                BigDecimal jcrysl = BigDecimal.valueOf(deptCb.getJcrysl());
                BigDecimal jcdwsl = BigDecimal.valueOf(deptCb.getJcdwsl());
                BigDecimal yxbzsl = BigDecimal.valueOf(deptCb.getYxbzsl());
                BigDecimal fyje = sjFybpZb.getFyje()!=null?sjFybpZb.getFyje():new BigDecimal(0);
                fyje=fyje.setScale(2,BigDecimal.ROUND_HALF_UP);
                if("油气生产单位".equals(dwlx)){
                    //计算标准
                    jyqlhjysr= deptCb.getJyqlhjysr().multiply(new BigDecimal(10000));//万吨 换算成吨
                    BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(2)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal bzs=yxbzsl.multiply(new BigDecimal(20000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal sum=jys.add(rys).add(dws).add(bzs);
                    sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    if(fyje.compareTo(sum)>-1){
                        sjFybpZb.setJl("费用总额"+fyje+"万元不低于"+sum+"万元。");
                        sjFybpZb.setJlflag(true);
                    }else {
                        sjFybpZb.setJl("费用总额"+fyje+"万元低于"+sum+"万元。");
                        sjFybpZb.setJlflag(false);
                    }
                    sjFybpZb.setJsbzSum(sum.toString());
                    sjFybpZb.setJsbz("计算标准为："
                            +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum);
                    sjFybpZb.setTqbz("交油气量（万吨）×2 元/吨×30%+基层人员数量×1000 元/人×30%+\n" +
                            "基层单位数量×15 万元/单位×20%+一线班站数量×2 万元/班站×20%");

                }else if("专业化单位".equals(dwlx)) {
                    //计算标准
                    if(yxbzsl.equals(new BigDecimal(0))){
                        BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.4)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal sum=jys.add(rys).add(dws);
                        sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        if(fyje.compareTo(sum)>-1){
                            sjFybpZb.setJl("费用总额"+fyje+"万元不低于"+sum+"万元。");
                            sjFybpZb.setJlflag(true);
                        }else {
                            sjFybpZb.setJl("费用总额"+fyje+"万元低于"+sum+"万元。");
                            sjFybpZb.setJlflag(false);
                        }
                        sjFybpZb.setJsbzSum(sum.toString());
                        sjFybpZb.setJsbz("计算标准为："
                                +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*15万元/单位*30%="+sum);
                        sjFybpZb.setTqbz("经营收入（万元）×1‰×30%+基层人员数量×1000 元/人×40%+基层\n" +
                                "单位数量×15 万元/单位×30%");
                    }else {
                        BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal dws=jcdwsl.multiply(new BigDecimal(150000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal bzs=yxbzsl.multiply(new BigDecimal(20000)).multiply(new BigDecimal(0.2)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        BigDecimal sum=jys.add(rys).add(dws).add(bzs);
                        sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                        if(fyje.compareTo(sum)>-1){
                            sjFybpZb.setJl("费用总额"+fyje+"万元不低于"+sum+"万元。");
                            sjFybpZb.setJlflag(true);
                        }else {
                            sjFybpZb.setJl("费用总额"+fyje+"万元低于"+sum+"万元。");
                            sjFybpZb.setJlflag(false);
                        }
                        sjFybpZb.setJsbzSum(sum.toString());
                        sjFybpZb.setJsbz("计算标准为："
                                +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*30%+"+jcdwsl+"*15万元/单位*20%+"+yxbzsl+"*2万元/班站*20%="+sum);
                        sjFybpZb.setTqbz("经营收入（万元）×1‰×30%+基层人员数量×1000 元/人×30%+基层\n" +
                                "单位数量×15 万元/单位×20%+一线班站数量×2 万元/班站×20%");
                    }
                }else if("科研监督单位".equals(dwlx)) {
                    BigDecimal jys= jyqlhjysr.multiply(new BigDecimal(0.0001)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal rys=jcrysl.multiply(new BigDecimal(1000)).multiply(new BigDecimal(0.4)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal dws=jcdwsl.multiply(new BigDecimal(50000)).multiply(new BigDecimal(0.3)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    BigDecimal sum=jys.add(rys).add(dws);
                    sum=sum.divide(new BigDecimal(10000)).setScale(2,BigDecimal.ROUND_HALF_UP);
                    if(fyje.compareTo(sum)>-1){
                        sjFybpZb.setJl("费用总额"+fyje+"万元不低于"+sum+"万元。");
                        sjFybpZb.setJlflag(true);
                    }else {
                        sjFybpZb.setJl("费用总额"+fyje+"万元低于"+sum+"万元。");
                        sjFybpZb.setJlflag(false);
                    }
                    sjFybpZb.setJsbzSum(sum.toString());
                    sjFybpZb.setJsbz("计算标准为："
                            +deptCb.getJyqlhjysr().setScale(2,BigDecimal.ROUND_HALF_UP)+"万吨*2元/吨*30%+"+jcrysl+"*1000元/人*40%+"+jcdwsl+"*5万元/单位*30%="+sum);
                    sjFybpZb.setTqbz("经营收入（万元）×1‰×30%+基层人员数量×1000 元/人×40%+基层\n" +
                            "单位数量×5 万元/单位×30%");
                }
            }
        }

        return sjFybpZb;
    }

}
