package com.qianhe.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.domain.SjZdbfZsdwkhpjZb;
import com.qianhe.service.ISjZdbfJcdwkhpjZbService;
import com.qianhe.service.ISjZdbfZsdwkhpjZbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 指导帮扶-基层单位考核评价主Controller
 *
 * @author qianhe
 * @date 2024-07-24
 */
@RestController
@RequestMapping("/system/sjZdbfJcdwkhpjZb")
public class SjZdbfJcdwkhpjZbController extends BaseController
{
    @Autowired
    private ISjZdbfJcdwkhpjZbService sjZdbfZsdwkhpjZbService;


    /**
     * 查询指导帮扶-基层单位考核评价主列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfJcdwkhpjZb:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        startPage();
        List<SjZdbfZsdwkhpjZb> list = sjZdbfZsdwkhpjZbService.selectSjZdbfZsdwkhpjZbList(sjZdbfZsdwkhpjZb);
        return getDataTable(list);
    }




    /**
     * 导出指导帮扶-基层单位考核评价主列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfJcdwkhpjZb:export')")
    @Log(title = "指导帮扶-基层单位考核评价主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        List<SjZdbfZsdwkhpjZb> list = sjZdbfZsdwkhpjZbService.selectSjZdbfZsdwkhpjZbList(sjZdbfZsdwkhpjZb);
        ExcelUtil<SjZdbfZsdwkhpjZb> util = new ExcelUtil<SjZdbfZsdwkhpjZb>(SjZdbfZsdwkhpjZb.class);
        util.exportExcel(response, list, "指导帮扶-基层单位考核评价主数据");
    }

    /**
     * 获取指导帮扶-基层单位考核评价主详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfJcdwkhpjZb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZdbfZsdwkhpjZbService.selectSjZdbfZsdwkhpjZbById(id));
    }

    /**
     * 新增指导帮扶-基层单位考核评价主
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfJcdwkhpjZb:add')")
    @Log(title = "指导帮扶-基层单位考核评价主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        return toAjax(sjZdbfZsdwkhpjZbService.insertSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb));
    }

    /**
     * 修改指导帮扶-基层单位考核评价主
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfJcdwkhpjZb:edit')")
    @Log(title = "指导帮扶-基层单位考核评价主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        return toAjax(sjZdbfZsdwkhpjZbService.updateSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb));
    }

    /**
     * 删除指导帮扶-基层单位考核评价主
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfJcdwkhpjZb:remove')")
    @Log(title = "指导帮扶-基层单位考核评价主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZdbfZsdwkhpjZbService.deleteSjZdbfZsdwkhpjZbByIds(ids));
    }
}
