package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.domain.SjZdbfKhpjbzCb;
import com.qianhe.mapper.SjZdbfKhpjbzMapper;
import com.qianhe.domain.SjZdbfKhpjbz;
import com.qianhe.service.ISjZdbfKhpjbzService;

/**
 * 指导帮扶-考核评价标准Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-22
 */
@Service
public class SjZdbfKhpjbzServiceImpl implements ISjZdbfKhpjbzService
{
    @Autowired
    private SjZdbfKhpjbzMapper sjZdbfKhpjbzMapper;

    /**
     * 查询指导帮扶-考核评价标准
     *
     * @param id 指导帮扶-考核评价标准主键
     * @return 指导帮扶-考核评价标准
     */
    @Override
    public SjZdbfKhpjbz selectSjZdbfKhpjbzById(Long id)
    {
        SjZdbfKhpjbz sjZdbfKhpjbz = sjZdbfKhpjbzMapper.selectSjZdbfKhpjbzById(id);
        List<SjZdbfKhpjbzCb> cbs=sjZdbfKhpjbzMapper.selectSjZdbfKhpjbzCbById(id);
        sjZdbfKhpjbz.setSjZdbfKhpjbzCbList(cbs);
        return sjZdbfKhpjbz;
    }

    /**
     * 查询指导帮扶-考核评价标准列表
     *
     * @param sjZdbfKhpjbz 指导帮扶-考核评价标准
     * @return 指导帮扶-考核评价标准
     */
    @Override
    public List<SjZdbfKhpjbz> selectSjZdbfKhpjbzList(SjZdbfKhpjbz sjZdbfKhpjbz)
    {
        return sjZdbfKhpjbzMapper.selectSjZdbfKhpjbzList(sjZdbfKhpjbz);
    }

    /**
     * 新增指导帮扶-考核评价标准
     *
     * @param sjZdbfKhpjbz 指导帮扶-考核评价标准
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjZdbfKhpjbz(SjZdbfKhpjbz sjZdbfKhpjbz)
    {
        sjZdbfKhpjbz.setCreateTime(DateUtils.getNowDate());
        sjZdbfKhpjbz.setCreateBy(SecurityUtils.getUsername());
        int rows = sjZdbfKhpjbzMapper.insertSjZdbfKhpjbz(sjZdbfKhpjbz);
        insertSjZdbfKhpjbzCb(sjZdbfKhpjbz);
        return rows;
    }

    /**
     * 修改指导帮扶-考核评价标准
     *
     * @param sjZdbfKhpjbz 指导帮扶-考核评价标准
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjZdbfKhpjbz(SjZdbfKhpjbz sjZdbfKhpjbz)
    {
        sjZdbfKhpjbz.setUpdateTime(DateUtils.getNowDate());
        sjZdbfKhpjbz.setUpdateBy(SecurityUtils.getUsername());
        sjZdbfKhpjbzMapper.deleteSjZdbfKhpjbzCbByZbId(sjZdbfKhpjbz.getId());
        insertSjZdbfKhpjbzCb(sjZdbfKhpjbz);
        return sjZdbfKhpjbzMapper.updateSjZdbfKhpjbz(sjZdbfKhpjbz);
    }

    /**
     * 批量删除指导帮扶-考核评价标准
     *
     * @param ids 需要删除的指导帮扶-考核评价标准主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjZdbfKhpjbzByIds(Long[] ids)
    {
        sjZdbfKhpjbzMapper.deleteSjZdbfKhpjbzCbByZbIds(ids);
        return sjZdbfKhpjbzMapper.deleteSjZdbfKhpjbzByIds(ids);
    }

    /**
     * 删除指导帮扶-考核评价标准信息
     *
     * @param id 指导帮扶-考核评价标准主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjZdbfKhpjbzById(Long id)
    {
        sjZdbfKhpjbzMapper.deleteSjZdbfKhpjbzCbByZbId(id);
        return sjZdbfKhpjbzMapper.deleteSjZdbfKhpjbzById(id);
    }

    @Override
    public List<SjZdbfKhpjbz> selectSjZdbfKhpjbzCxList(SjZdbfKhpjbz sjZdbfKhpjbz) {
        return sjZdbfKhpjbzMapper.selectSjZdbfKhpjbzCxList(sjZdbfKhpjbz);
    }

    @Override
    public List<String> getKhnrList(SjZdbfKhpjbzCb cb) {
        return sjZdbfKhpjbzMapper.getKhnrList(cb);
    }

    @Override
    public List<String> getKhxdList(SjZdbfKhpjbzCb cb) {
        return sjZdbfKhpjbzMapper.getKhxdList(cb);
    }

    @Override
    public List<SjZdbfKhpjbzCb> getPjbzList(SjZdbfKhpjbzCb cb) {
        return sjZdbfKhpjbzMapper.getPjbzList(cb);
    }

    /**
     * 新增指导帮扶-考核评价标准从信息
     *
     * @param sjZdbfKhpjbz 指导帮扶-考核评价标准对象
     */
    public void insertSjZdbfKhpjbzCb(SjZdbfKhpjbz sjZdbfKhpjbz)
    {
        List<SjZdbfKhpjbzCb> sjZdbfKhpjbzCbList = sjZdbfKhpjbz.getSjZdbfKhpjbzCbList();
        Long id = sjZdbfKhpjbz.getId();
        if (StringUtils.isNotNull(sjZdbfKhpjbzCbList))
        {
            List<SjZdbfKhpjbzCb> list = new ArrayList<SjZdbfKhpjbzCb>();
            for (int i=0;i<sjZdbfKhpjbzCbList.size();i++)
            {
                SjZdbfKhpjbzCb sjZdbfKhpjbzCb = sjZdbfKhpjbzCbList.get(i);
                sjZdbfKhpjbzCb.setCreateBy(SecurityUtils.getUsername());
                sjZdbfKhpjbzCb.setCreateTime(DateUtils.getNowDate());
                sjZdbfKhpjbzCb.setKhnr(sjZdbfKhpjbz.getKhnr());
                sjZdbfKhpjbzCb.setKhxd(sjZdbfKhpjbz.getKhxd());
                sjZdbfKhpjbzCb.setLx(sjZdbfKhpjbz.getLx());
                sjZdbfKhpjbzCb.setNd(sjZdbfKhpjbz.getNd());
                sjZdbfKhpjbzCb.setZbId(id);
                sjZdbfKhpjbzCb.setPx(i+1L);
                list.add(sjZdbfKhpjbzCb);
            }
            if (list.size() > 0)
            {
                sjZdbfKhpjbzMapper.batchSjZdbfKhpjbzCb(list);
            }
        }
    }
}
