package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.domain.SjZdbfFjxbzCb;
import com.qianhe.mapper.SjZdbfFjxbzMapper;
import com.qianhe.domain.SjZdbfFjxbz;
import com.qianhe.service.ISjZdbfFjxbzService;

/**
 * 指导帮扶-否决项标准Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-22
 */
@Service
public class SjZdbfFjxbzServiceImpl implements ISjZdbfFjxbzService
{
    @Autowired
    private SjZdbfFjxbzMapper sjZdbfFjxbzMapper;

    /**
     * 查询指导帮扶-否决项标准
     *
     * @param id 指导帮扶-否决项标准主键
     * @return 指导帮扶-否决项标准
     */
    @Override
    public SjZdbfFjxbz selectSjZdbfFjxbzById(Long id)
    {
        SjZdbfFjxbz sjZdbfFjxbz = sjZdbfFjxbzMapper.selectSjZdbfFjxbzById(id);
        List<SjZdbfFjxbzCb> cbList=sjZdbfFjxbzMapper.selectSjZdbfFjxbzCbById(id);
        sjZdbfFjxbz.setSjZdbfFjxbzCbList(cbList);
        return sjZdbfFjxbz;
    }

    /**
     * 查询指导帮扶-否决项标准列表
     *
     * @param sjZdbfFjxbz 指导帮扶-否决项标准
     * @return 指导帮扶-否决项标准
     */
    @Override
    public List<SjZdbfFjxbz> selectSjZdbfFjxbzList(SjZdbfFjxbz sjZdbfFjxbz)
    {
        return sjZdbfFjxbzMapper.selectSjZdbfFjxbzList(sjZdbfFjxbz);
    }

    /**
     * 新增指导帮扶-否决项标准
     *
     * @param sjZdbfFjxbz 指导帮扶-否决项标准
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSjZdbfFjxbz(SjZdbfFjxbz sjZdbfFjxbz)
    {
        sjZdbfFjxbz.setCreateTime(DateUtils.getNowDate());
        int rows = sjZdbfFjxbzMapper.insertSjZdbfFjxbz(sjZdbfFjxbz);
        insertSjZdbfFjxbzCb(sjZdbfFjxbz);
        return rows;
    }

    /**
     * 修改指导帮扶-否决项标准
     *
     * @param sjZdbfFjxbz 指导帮扶-否决项标准
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSjZdbfFjxbz(SjZdbfFjxbz sjZdbfFjxbz)
    {
        sjZdbfFjxbz.setUpdateTime(DateUtils.getNowDate());
        sjZdbfFjxbzMapper.deleteSjZdbfFjxbzCbByZbId(sjZdbfFjxbz.getId());
        insertSjZdbfFjxbzCb(sjZdbfFjxbz);
        return sjZdbfFjxbzMapper.updateSjZdbfFjxbz(sjZdbfFjxbz);
    }

    /**
     * 批量删除指导帮扶-否决项标准
     *
     * @param ids 需要删除的指导帮扶-否决项标准主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjZdbfFjxbzByIds(Long[] ids)
    {
        sjZdbfFjxbzMapper.deleteSjZdbfFjxbzCbByZbIds(ids);
        return sjZdbfFjxbzMapper.deleteSjZdbfFjxbzByIds(ids);
    }

    /**
     * 删除指导帮扶-否决项标准信息
     *
     * @param id 指导帮扶-否决项标准主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSjZdbfFjxbzById(Long id)
    {
        sjZdbfFjxbzMapper.deleteSjZdbfFjxbzCbByZbId(id);
        return sjZdbfFjxbzMapper.deleteSjZdbfFjxbzById(id);
    }

    @Override
    public List<SjZdbfFjxbz> selectSjZdbfFjxbzCxList(SjZdbfFjxbz sjZdbfFjxbz) {
        return sjZdbfFjxbzMapper.selectSjZdbfFjxbzCxList(sjZdbfFjxbz);
    }

    @Override
    public List<String> getFlmcList(SjZdbfFjxbzCb cb) {
        return sjZdbfFjxbzMapper.getFlmcList(cb);
    }

    @Override
    public List<SjZdbfFjxbzCb> getPjbzList(SjZdbfFjxbzCb cb) {
        return sjZdbfFjxbzMapper.getPjbzList(cb);
    }

    /**
     * 新增指导帮扶-否决项标准从信息
     *
     * @param sjZdbfFjxbz 指导帮扶-否决项标准对象
     */
    public void insertSjZdbfFjxbzCb(SjZdbfFjxbz sjZdbfFjxbz)
    {
        List<SjZdbfFjxbzCb> sjZdbfFjxbzCbList = sjZdbfFjxbz.getSjZdbfFjxbzCbList();
        Long id = sjZdbfFjxbz.getId();
        if (StringUtils.isNotNull(sjZdbfFjxbzCbList))
        {
            List<SjZdbfFjxbzCb> list = new ArrayList<SjZdbfFjxbzCb>();
            for (int i=0;i<sjZdbfFjxbzCbList.size();i++)
            {
                SjZdbfFjxbzCb sjZdbfFjxbzCb = sjZdbfFjxbzCbList.get(i);
                sjZdbfFjxbzCb.setFlmc(sjZdbfFjxbz.getFlmc());
                sjZdbfFjxbzCb.setNd(sjZdbfFjxbz.getNd());
                sjZdbfFjxbzCb.setPx(i+1L);
                sjZdbfFjxbzCb.setZbId(id);
                list.add(sjZdbfFjxbzCb);
            }
            if (list.size() > 0)
            {
                sjZdbfFjxbzMapper.batchSjZdbfFjxbzCb(list);
            }
        }
    }
}
