package com.qianhe.service.impl;

import com.qianhe.common.core.domain.TreeSelect;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.utils.spring.SpringUtils;
import com.qianhe.domain.SjGfjsBfzbfdx;
import com.qianhe.domain.SjGfjsBfzwh;
import com.qianhe.mapper.SjGfjsBfzwhMapper;
import com.qianhe.service.ISjGfjsBfzwhService;
import com.qianhe.system.domain.SysUserRole;
import com.qianhe.system.mapper.SysUserRoleMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 三基帮扶组维护Service业务层处理
 *
 * @author qianhe
 * @date 2024-08-31
 */
@Service
public class SjGfjsBfzwhServiceImpl implements ISjGfjsBfzwhService
{
    @Autowired
    private SjGfjsBfzwhMapper sjGfjsBfzwhMapper;

    /**
     * 查询三基帮扶组维护
     *
     * @param id 三基帮扶组维护主键
     * @return 三基帮扶组维护
     */
    @Override
    public SjGfjsBfzwh selectSjGfjsBfzwhById(Long id)
    {
        return sjGfjsBfzwhMapper.selectSjGfjsBfzwhById(id);
    }

    /**
     * 根据联系人查询三基帮扶组
     */
    @Override
    public SjGfjsBfzwh selectbfz(String lxr)
    {
        return sjGfjsBfzwhMapper.selectbfz(lxr);
    }

    /**
     * 查询三基帮扶组维护列表
     *
     * @param sjGfjsBfzwh 三基帮扶组维护
     * @return 三基帮扶组维护
     */
    @Override
    public List<SjGfjsBfzwh> selectSjGfjsBfzwhList(SjGfjsBfzwh sjGfjsBfzwh)
    {
        return sjGfjsBfzwhMapper.selectSjGfjsBfzwhList(sjGfjsBfzwh);
    }

    @Autowired
    private SysUserRoleMapper userRoleMapper;
    /**
     * 新增三基帮扶组维护
     *
     * @param sjGfjsBfzwh 三基帮扶组维护
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSjGfjsBfzwh(SjGfjsBfzwh sjGfjsBfzwh)
    {
        // 给联系人一个帮扶组角色
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sjGfjsBfzwh.getLxr());
        userRole.setRoleId(new Long(104));
        userRoleMapper.deleteUserRoleInfo(userRole);
        userRoleMapper.insertUserRole(userRole);

        sjGfjsBfzwhMapper.insertSjGfjsBfzwh(sjGfjsBfzwh);
        return insertBfzBfdx(sjGfjsBfzwh);
    }

    /**
     * 新增帮扶组帮扶对象信息
     *
     */
    public int insertBfzBfdx(SjGfjsBfzwh sjGfjsBfzwh)
    {
        int rows = 1;
        List<SjGfjsBfzbfdx> list = new ArrayList<SjGfjsBfzbfdx>();
        for (Long deptId : sjGfjsBfzwh.getDeptIds())
        {
            SjGfjsBfzbfdx rm = new SjGfjsBfzbfdx();
            rm.setId(sjGfjsBfzwh.getId());
            rm.setDeptId(deptId);
            list.add(rm);
        }
        if (list.size() > 0)
        {
            rows = sjGfjsBfzwhMapper.batchBfzBfdx(list);
        }
        return rows;
    }

    /**
     * 修改三基帮扶组维护
     *
     * @param sjGfjsBfzwh 三基帮扶组维护
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSjGfjsBfzwh(SjGfjsBfzwh sjGfjsBfzwh)
    {
        // 给联系人一个帮扶组角色
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sjGfjsBfzwh.getLxr());
        userRole.setRoleId(new Long(104));
        userRoleMapper.deleteUserRoleInfo(userRole);
        userRoleMapper.insertUserRole(userRole);

        sjGfjsBfzwhMapper.updateSjGfjsBfzwh(sjGfjsBfzwh);
        // 删除帮扶组与帮扶对象关联
        sjGfjsBfzwhMapper.deleteBfzBfdxById(sjGfjsBfzwh.getId());
        return insertBfzBfdx(sjGfjsBfzwh);
    }

    /**
     * 批量删除三基帮扶组维护
     *
     * @param ids 需要删除的三基帮扶组维护主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteSjGfjsBfzwhByIds(Long[] ids)
    {
        sjGfjsBfzwhMapper.deleteBfzBfdx(ids);
        return sjGfjsBfzwhMapper.deleteSjGfjsBfzwhByIds(ids);
    }

    /**
     * 删除三基帮扶组维护信息
     *
     * @param id 三基帮扶组维护主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteSjGfjsBfzwhById(Long id)
    {
        sjGfjsBfzwhMapper.deleteBfzBfdxById(id);
        return sjGfjsBfzwhMapper.deleteSjGfjsBfzwhById(id);
    }

    @Override
    public List<Long> selectBfdxListByBfz(Long id)
    {
        return sjGfjsBfzwhMapper.selectBfdxListByBfz(id);
    }

    /**
     * 构建前端所需要下拉树结构
     *
     * @param depts 菜单列表
     * @return 下拉树结构列表
     */
    @Override
    public List<TreeSelect> buildBfdwTreeSelect(List<SysDept> depts)
    {
        List<SysDept> deptTrees = buildBfdwxTree(depts);
        return deptTrees.stream().map(TreeSelect::new).collect(Collectors.toList());
    }

    /**
     * 构建前端所需要树结构
     *
     * @param depts 单位列表
     * @return 树结构列表
     */
    @Override
    public List<SysDept> buildBfdwxTree(List<SysDept> depts)
    {
        List<SysDept> returnList = new ArrayList<SysDept>();
        List<Long> tempList = depts.stream().map(SysDept::getDeptId).collect(Collectors.toList());
        for (Iterator<SysDept> iterator = depts.iterator(); iterator.hasNext();)
        {
            SysDept menu = (SysDept) iterator.next();
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if (!tempList.contains(menu.getParentId()))
            {
                recursionFn(depts, menu);
                returnList.add(menu);
            }
        }
        if (returnList.isEmpty())
        {
            returnList = depts;
        }
        return returnList;
    }

    /**
     * 递归列表
     *
     * @param list 分类表
     * @param t 子节点
     */
    private void recursionFn(List<SysDept> list, SysDept t)
    {
        // 得到子节点列表
        List<SysDept> childList = getChildList(list, t);
        t.setChildren(childList);
        for (SysDept tChild : childList)
        {
            if (hasChild(list, tChild))
            {
                recursionFn(list, tChild);
            }
        }
    }

    /**
     * 得到子节点列表
     */
    private List<SysDept> getChildList(List<SysDept> list, SysDept t)
    {
        List<SysDept> tlist = new ArrayList<SysDept>();
        Iterator<SysDept> it = list.iterator();
        while (it.hasNext())
        {
            SysDept n = (SysDept) it.next();
            if (n.getParentId().longValue() == t.getDeptId().longValue())
            {
                tlist.add(n);
            }
        }
        return tlist;
    }

    /**
     * 判断是否有子节点
     */
    private boolean hasChild(List<SysDept> list, SysDept t)
    {
        return getChildList(list, t).size() > 0;
    }


    @Override
    public List<SjGfjsBfzbfdx> selectBfdxlist(SjGfjsBfzbfdx sjGfjsBfzbfdx)
    {
        return sjGfjsBfzwhMapper.selectBfdxlist(sjGfjsBfzbfdx);
    }


    @Override
    public List<TreeSelect> selectBfdxTree(SjGfjsBfzbfdx sjGfjsBfzbfdx)
    {
        List<SysDept> depts = SpringUtils.getAopProxy(this).selectBfdxTree_list(sjGfjsBfzbfdx);
        return buildDeptTreeSelect(depts);
    }

    @Override
    public List<SysDept> selectBfdxTree_list(SjGfjsBfzbfdx sjGfjsBfzbfdx)
    {
        return sjGfjsBfzwhMapper.selectBfdxTree_list(sjGfjsBfzbfdx);
    }

    @Override
    public List<TreeSelect> buildDeptTreeSelect(List<SysDept> depts)
    {
        List<SysDept> deptTrees = buildDeptTree(depts);
        return deptTrees.stream().map(TreeSelect::new).collect(Collectors.toList());
    }
    /**
     * 构建前端所需要树结构
     *
     * @param depts 部门列表
     * @return 树结构列表
     */
    @Override
    public List<SysDept> buildDeptTree(List<SysDept> depts)
    {
        List<SysDept> returnList = new ArrayList<SysDept>();
        List<Long> tempList = depts.stream().map(SysDept::getDeptId).collect(Collectors.toList());
        for (SysDept dept : depts)
        {
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if (!tempList.contains(dept.getParentId()))
            {
                recursionFn(depts, dept);
                returnList.add(dept);
            }
        }
        if (returnList.isEmpty())
        {
            returnList = depts;
        }
        return returnList;
    }

}
