package com.qianhe.service.impl;

import java.util.Iterator;
import java.util.List;

import cn.hutool.core.codec.Base64;
import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.bean.BeanUtils;
import com.qianhe.domain.BzscCyglqglscCb;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.stream.Collectors;

import com.qianhe.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.qianhe.domain.BzscZczscCb;
import com.qianhe.mapper.BzscZczscZbMapper;
import com.qianhe.domain.BzscZczscZb;
import com.qianhe.service.IBzscZczscZbService;

/**
 * 标准手册-注采站管理手册-主Service业务层处理
 *
 * @author qianhe
 * @date 2024-09-11
 */
@Service
public class BzscZczscZbServiceImpl implements IBzscZczscZbService
{
    @Autowired
    private BzscZczscZbMapper bzscZczscZbMapper;

    /**
     * 查询标准手册-注采站管理手册-主
     *
     * @param ID 标准手册-注采站管理手册-主主键
     * @return 标准手册-注采站管理手册-主
     */
    @Override
    public BzscZczscZb selectBzscZczscZbByID(Long ID)
    {
        BzscZczscZb bzscZczscZb = bzscZczscZbMapper.selectBzscZczscZbByID(ID);
        //查询从表
        List<BzscZczscCb> cbList=bzscZczscZbMapper.selectBzscZczscCbByID(ID);
        bzscZczscZb.setBzscZczscCbList(buildDeptTree(cbList));
        return bzscZczscZb;
    }

    /**
     * 查询标准手册-注采站管理手册-主列表
     *
     * @param bzscZczscZb 标准手册-注采站管理手册-主
     * @return 标准手册-注采站管理手册-主
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<BzscZczscZb> selectBzscZczscZbList(BzscZczscZb bzscZczscZb)
    {
        return bzscZczscZbMapper.selectBzscZczscZbList(bzscZczscZb);
    }

    /**
     * 新增标准手册-注采站管理手册-主
     *
     * @param bzscZczscZb 标准手册-注采站管理手册-主
     * @return 结果
     */
    @Transactional
    @Override
    public int insertBzscZczscZb(BzscZczscZb bzscZczscZb)
    {
        bzscZczscZb.setCreateTime(DateUtils.getNowDate());
        bzscZczscZb.setCreateBy(SecurityUtils.getUsername());
        int rows = bzscZczscZbMapper.insertBzscZczscZb(bzscZczscZb);
        insertBzscZczscCb(bzscZczscZb);

        return rows;
    }

    /**
     * 修改标准手册-注采站管理手册-主
     *
     * @param bzscZczscZb 标准手册-注采站管理手册-主
     * @return 结果
     */
    @Transactional
    @Override
    public int updateBzscZczscZb(BzscZczscZb bzscZczscZb)
    {
        bzscZczscZb.setUpdateTime(DateUtils.getNowDate());
        bzscZczscZb.setUpdateBy(SecurityUtils.getUsername());
        bzscZczscZbMapper.deleteBzscZczscCbByZbId(bzscZczscZb.getID());
        insertBzscZczscCb(bzscZczscZb);
        return bzscZczscZbMapper.updateBzscZczscZb(bzscZczscZb);
    }

    /**
     * 批量删除标准手册-注采站管理手册-主
     *
     * @param IDs 需要删除的标准手册-注采站管理手册-主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteBzscZczscZbByIDs(Long[] IDs)
    {
        bzscZczscZbMapper.deleteBzscZczscCbByZbIds(IDs);
        return bzscZczscZbMapper.deleteBzscZczscZbByIDs(IDs);
    }

    /**
     * 删除标准手册-注采站管理手册-主信息
     *
     * @param ID 标准手册-注采站管理手册-主主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteBzscZczscZbByID(Long ID)
    {
        bzscZczscZbMapper.deleteBzscZczscCbByZbId(ID);
        return bzscZczscZbMapper.deleteBzscZczscZbByID(ID);
    }

    /**
     * 新增标准手册-注采站管理手册-从信息
     *
     * @param bzscZczscZb 标准手册-注采站管理手册-主对象
     */
    public void insertBzscZczscCb(BzscZczscZb bzscZczscZb)
    {
        List<BzscZczscCb> bzscZczscCbList = bzscZczscZb.getBzscZczscCbList();
        Long ID = bzscZczscZb.getID();
        if (StringUtils.isNotNull(bzscZczscCbList))
        {
//            List<BzscZczscCb> list = new ArrayList<BzscZczscCb>();
            for (BzscZczscCb bzscZczscCb : bzscZczscCbList)
            {
                bzscZczscCb.setZbId(ID);
                bzscZczscCb.setParentId(0L);
                bzscZczscCb.setDeptId(bzscZczscZb.getDeptId());
                bzscZczscCb.setNd(bzscZczscZb.getNd());
                bzscZczscCb.setNr(new String(Base64.decode(bzscZczscCb.getNr())));
                bzscZczscZbMapper.insertBzscZczscCb(bzscZczscCb);
                if(StringUtils.isNotNull(bzscZczscCb.getChildList())){
                    for(BzscZczscCb cb1:bzscZczscCb.getChildList()){
                        cb1.setZbId(ID);
                        cb1.setParentId(bzscZczscCb.getID());
                        cb1.setDeptId(bzscZczscZb.getDeptId());
                        cb1.setNd(bzscZczscZb.getNd());
                        cb1.setNr(new String(Base64.decode(cb1.getNr())));
                        bzscZczscZbMapper.insertBzscZczscCb(cb1);
                        if(cb1.getChildList().size()>0){
                            for(BzscZczscCb cb2:cb1.getChildList()){
                                cb2.setZbId(ID);
                                cb2.setParentId(cb1.getID());
                                cb2.setDeptId(bzscZczscZb.getDeptId());
                                cb2.setNd(bzscZczscZb.getNd());
                                cb2.setNr(new String(Base64.decode(cb2.getNr())));
                                bzscZczscZbMapper.insertBzscZczscCb(cb2);
                            }
                        }else {
                            //一级分类没有子级 则本身添加一条子级
                            BzscZczscCb  cb2 =new BzscZczscCb();
                            BeanUtils.copyProperties(cb1,cb2);
                            cb2.setZbId(ID);
                            cb2.setParentId(cb1.getID());
                            cb2.setDeptId(bzscZczscZb.getDeptId());
                            cb2.setNd(bzscZczscZb.getNd());
                            cb2.setNr(new String(Base64.decode(cb2.getNr())));
                            bzscZczscZbMapper.insertBzscZczscCb(cb2);
                        }
                    }
                }

//                list.add(bzscZczscCb);
            }
//            if (list.size() > 0)
//            {
//                bzscZczscZbMapper.batchBzscZczscCb(list);
//            }
        }
    }




    public List<BzscZczscCb> buildDeptTree(List<BzscZczscCb> cbList)
    {
        List<BzscZczscCb> returnList = new ArrayList<BzscZczscCb>();
        List<Long> tempList = cbList.stream().map(BzscZczscCb::getID).collect(Collectors.toList());
        for (BzscZczscCb cb : cbList)
        {
            // 如果是顶级节点, 遍历该父节点的所有子节点
            if (!tempList.contains(cb.getParentId()))
            {
                recursionFn(cbList, cb);
                returnList.add(cb);
            }
        }
        if (returnList.isEmpty())
        {
            returnList = cbList;
        }
        return returnList;
    }

    /**
     * 递归列表
     */
    private void recursionFn(List<BzscZczscCb> list, BzscZczscCb t)
    {
        // 得到子节点列表
        List<BzscZczscCb> childList = getChildList(list, t);
        t.setChildList(childList);
        for (BzscZczscCb tChild : childList)
        {
            if (hasChild(list, tChild))
            {
                recursionFn(list, tChild);
            }
        }
    }

    /**
     * 得到子节点列表
     */
    private List<BzscZczscCb> getChildList(List<BzscZczscCb> list, BzscZczscCb t)
    {
        List<BzscZczscCb> tlist = new ArrayList<BzscZczscCb>();
        Iterator<BzscZczscCb> it = list.iterator();
        while (it.hasNext())
        {
            BzscZczscCb n = (BzscZczscCb) it.next();
            if (StringUtils.isNotNull(n.getParentId()) && n.getParentId().longValue() == t.getID().longValue())
            {
                tlist.add(n);
            }
        }
        return tlist;
    }

    /**
     * 判断是否有子节点
     */
    private boolean hasChild(List<BzscZczscCb> list, BzscZczscCb t)
    {
        return getChildList(list, t).size() > 0;
    }
}
