package com.qianhe.service;

import java.util.List;
import com.qianhe.domain.GgFjb;

/**
 * 公共附件Service接口
 * 
 * @author qianhe
 * @date 2025-08-04
 */
public interface IGgFjbService 
{
    /**
     * 查询公共附件
     * 
     * @param ID 公共附件主键
     * @return 公共附件
     */
    public GgFjb selectGgFjbByID(Long ID);

    /**
     * 查询公共附件列表
     * 
     * @param ggFjb 公共附件
     * @return 公共附件集合
     */
    public List<GgFjb> selectGgFjbList(GgFjb ggFjb);

    /**
     * 新增公共附件
     * 
     * @param ggFjb 公共附件
     * @return 结果
     */
    public int insertGgFjb(GgFjb ggFjb);

    /**
     * 修改公共附件
     * 
     * @param ggFjb 公共附件
     * @return 结果
     */
    public int updateGgFjb(GgFjb ggFjb);

    /**
     * 批量删除公共附件
     * 
     * @param IDs 需要删除的公共附件主键集合
     * @return 结果
     */
    public int deleteGgFjbByIDs(Long[] IDs);

    /**
     * 删除公共附件信息
     * 
     * @param ID 公共附件主键
     * @return 结果
     */
    public int deleteGgFjbByID(Long ID);




    public int batchSaveFj(String businessId, String fjlx, String mkmc, String fileListStr);
    List<GgFjb> selectFj(Long id, String mkmc);
    List<GgFjb> selectFjByMk(String mkmc);
    int deleteFjByYwid(GgFjb ggFjb);

}
