package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjFybpWh;
import com.qianhe.service.ISjFybpWhService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 三基-费用维护Controller
 *
 * @author qianhe
 * @date 2024-07-05
 */
@RestController
@RequestMapping("/system/sjFybpWh")
public class SjFybpWhController extends BaseController
{
    @Autowired
    private ISjFybpWhService sjFybpWhService;

    /**
     * 查询三基-费用维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpWh:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFybpWh sjFybpWh)
    {
//        startPage();
        List<SjFybpWh> list = sjFybpWhService.selectSjFybpWhList(sjFybpWh);
        return getDataTable(list);
    }

    /**
     * 导出三基-费用维护列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpWh:export')")
    @Log(title = "三基-费用维护", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFybpWh sjFybpWh)
    {
        List<SjFybpWh> list = sjFybpWhService.selectSjFybpWhList(sjFybpWh);
        ExcelUtil<SjFybpWh> util = new ExcelUtil<SjFybpWh>(SjFybpWh.class);
        util.exportExcel(response, list, "三基-费用维护数据");
    }

    /**
     * 获取三基-费用维护详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpWh:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFybpWhService.selectSjFybpWhById(id));
    }

    /**
     * 新增三基-费用维护
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpWh:add')")
    @Log(title = "三基-费用维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFybpWh sjFybpWh)
    {
        return toAjax(sjFybpWhService.insertSjFybpWh(sjFybpWh));
    }

    /**
     * 修改三基-费用维护
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpWh:edit')")
    @Log(title = "三基-费用维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFybpWh sjFybpWh)
    {
        return toAjax(sjFybpWhService.updateSjFybpWh(sjFybpWh));
    }

    /**
     * 删除三基-费用维护
     */
    @PreAuthorize("@ss.hasPermi('system:sjFybpWh:remove')")
    @Log(title = "三基-费用维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFybpWhService.deleteSjFybpWhByIds(ids));
    }
}
