package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.BzscYsjglggzscCb;
import com.qianhe.service.IBzscYsjglggzscCbService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;

import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-油水井管理岗工作手册-从Controller
 *
 * @author qianhe
 * @date 2024-10-09
 */
@RestController
@RequestMapping("/system/cb")
public class BzscYsjglggzscCbController extends BaseController
{
    @Autowired
    private IBzscYsjglggzscCbService bzscYsjglggzscCbService;

    /**
     * 查询标准手册-油水井管理岗工作手册-从列表
     */
    @PreAuthorize("@ss.hasPermi('system:cb:list')")
    @GetMapping("/list")
    public TableDataInfo list(BzscYsjglggzscCb bzscYsjglggzscCb)
    {
        startPage();
        List<BzscYsjglggzscCb> list = bzscYsjglggzscCbService.selectBzscYsjglggzscCbList(bzscYsjglggzscCb);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-油水井管理岗工作手册-从列表
     */
    @PreAuthorize("@ss.hasPermi('system:cb:export')")
    @Log(title = "标准手册-油水井管理岗工作手册-从", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscYsjglggzscCb bzscYsjglggzscCb)
    {
        List<BzscYsjglggzscCb> list = bzscYsjglggzscCbService.selectBzscYsjglggzscCbList(bzscYsjglggzscCb);
        ExcelUtil<BzscYsjglggzscCb> util = new ExcelUtil<BzscYsjglggzscCb>(BzscYsjglggzscCb.class);
        util.exportExcel(response, list, "标准手册-油水井管理岗工作手册-从数据");
    }

    /**
     * 获取标准手册-油水井管理岗工作手册-从详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:cb:query')")
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        return success(bzscYsjglggzscCbService.selectBzscYsjglggzscCbByID(ID));
    }

    /**
     * 新增标准手册-油水井管理岗工作手册-从
     */
    @PreAuthorize("@ss.hasPermi('system:cb:add')")
    @Log(title = "标准手册-油水井管理岗工作手册-从", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscYsjglggzscCb bzscYsjglggzscCb)
    {
        return toAjax(bzscYsjglggzscCbService.insertBzscYsjglggzscCb(bzscYsjglggzscCb));
    }

    /**
     * 修改标准手册-油水井管理岗工作手册-从
     */
    @PreAuthorize("@ss.hasPermi('system:cb:edit')")
    @Log(title = "标准手册-油水井管理岗工作手册-从", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscYsjglggzscCb bzscYsjglggzscCb)
    {
        return toAjax(bzscYsjglggzscCbService.updateBzscYsjglggzscCb(bzscYsjglggzscCb));
    }

    /**
     * 删除标准手册-油水井管理岗工作手册-从
     */
    @PreAuthorize("@ss.hasPermi('system:cb:remove')")
    @Log(title = "标准手册-油水井管理岗工作手册-从", businessType = BusinessType.DELETE)
	@DeleteMapping("/{IDs}")
    public AjaxResult remove(@PathVariable Long[] IDs)
    {
        return toAjax(bzscYsjglggzscCbService.deleteBzscYsjglggzscCbByIDs(IDs));
    }
}
