package com.qianhe.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.BzscCyglqglscCb;
import com.qianhe.domain.BzscSczhzxscCb;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.BzscSczhzxscZb;
import com.qianhe.service.IBzscSczhzxscZbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-生产指挥中心管理手册-主Controller
 *
 * @author qianhe
 * @date 2024-09-19
 */
@RestController
@RequestMapping("/system/bzscSczhzxscZb")
public class BzscSczhzxscZbController extends BaseController
{
    @Autowired
    private IBzscSczhzxscZbService bzscSczhzxscZbService;

    /**
     * 查询标准手册-生产指挥中心管理手册-主列表
     */
    @PreAuthorize("@ss.hasPermi('system:bzscSczhzxscZb:list')")
    @GetMapping("/list")
    public TableDataInfo list(BzscSczhzxscZb bzscSczhzxscZb)
    {
        startPage();
        List<BzscSczhzxscZb> list = bzscSczhzxscZbService.selectBzscSczhzxscZbList(bzscSczhzxscZb);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-生产指挥中心管理手册-主列表
     */
    @PreAuthorize("@ss.hasPermi('system:bzscSczhzxscZb:export')")
    @Log(title = "标准手册-生产指挥中心管理手册-主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscSczhzxscZb bzscSczhzxscZb)
    {
        List<BzscSczhzxscZb> list = bzscSczhzxscZbService.selectBzscSczhzxscZbList(bzscSczhzxscZb);
        ExcelUtil<BzscSczhzxscZb> util = new ExcelUtil<BzscSczhzxscZb>(BzscSczhzxscZb.class);
        util.exportExcel(response, list, "标准手册-生产指挥中心管理手册-主数据");
    }

    /**
     * 获取标准手册-生产指挥中心管理手册-主详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:bzscSczhzxscZb:query')")
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        BzscSczhzxscZb bzscSczhzxscZb = bzscSczhzxscZbService.selectBzscSczhzxscZbByID(ID);

        Map<String,Object> map =new HashMap<>();
        BzscSczhzxscCb cb = bzscSczhzxscZb.getBzscSczhzxscCbList().size() > 0 ? bzscSczhzxscZb.getBzscSczhzxscCbList().get(0) : null;
        map.put("nr",cb!=null ?cb.getChildList():new ArrayList<BzscCyglqglscCb>());
        if(cb!=null){
            cb.setChildList(new ArrayList<>());
        }
        map.put("bt",cb);
        bzscSczhzxscZb.setBzscSczhzxscCbList(new ArrayList<>());
        map.put("bzscSczhzxscZb",bzscSczhzxscZb);
        return success(map);
    }

    /**
     * 新增标准手册-生产指挥中心管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscSczhzxscZb:add')")
    @Log(title = "标准手册-生产指挥中心管理手册-主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscSczhzxscZb bzscSczhzxscZb)
    {
        return toAjax(bzscSczhzxscZbService.insertBzscSczhzxscZb(bzscSczhzxscZb));
    }

    /**
     * 修改标准手册-生产指挥中心管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscSczhzxscZb:edit')")
    @Log(title = "标准手册-生产指挥中心管理手册-主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscSczhzxscZb bzscSczhzxscZb)
    {
        return toAjax(bzscSczhzxscZbService.updateBzscSczhzxscZb(bzscSczhzxscZb));
    }

    /**
     * 删除标准手册-生产指挥中心管理手册-主
     */
    @PreAuthorize("@ss.hasPermi('system:bzscSczhzxscZb:remove')")
    @Log(title = "标准手册-生产指挥中心管理手册-主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{IDs}")
    public AjaxResult remove(@PathVariable Long[] IDs)
    {
        return toAjax(bzscSczhzxscZbService.deleteBzscSczhzxscZbByIDs(IDs));
    }
}
