package com.qianhe.bzsc.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.bzsc.mapper.BzscCyglqglscMbzbMapper;
import com.qianhe.bzsc.domain.BzscCyglqglscMbzb;
import com.qianhe.bzsc.service.IBzscCyglqglscMbzbService;

/**
 * 标准手册-采油管理区管理手册-模板主Service业务层处理
 *
 * @author qianhe
 * @date 2024-11-11
 */
@Service
public class BzscCyglqglscMbzbServiceImpl implements IBzscCyglqglscMbzbService
{
    @Autowired
    private BzscCyglqglscMbzbMapper bzscCyglqglscMbzbMapper;

    /**
     * 查询标准手册-采油管理区管理手册-模板主
     *
     * @param ID 标准手册-采油管理区管理手册-模板主主键
     * @return 标准手册-采油管理区管理手册-模板主
     */
    @Override
    public BzscCyglqglscMbzb selectBzscCyglqglscMbzbByID(Long ID)
    {
        return bzscCyglqglscMbzbMapper.selectBzscCyglqglscMbzbByID(ID);
    }

    /**
     * 查询标准手册-采油管理区管理手册-模板主列表
     *
     * @param bzscCyglqglscMbzb 标准手册-采油管理区管理手册-模板主
     * @return 标准手册-采油管理区管理手册-模板主
     */
    @Override
    public List<BzscCyglqglscMbzb> selectBzscCyglqglscMbzbList(BzscCyglqglscMbzb bzscCyglqglscMbzb)
    {
        return bzscCyglqglscMbzbMapper.selectBzscCyglqglscMbzbList(bzscCyglqglscMbzb);
    }

    /**
     * 新增标准手册-采油管理区管理手册-模板主
     *
     * @param bzscCyglqglscMbzb 标准手册-采油管理区管理手册-模板主
     * @return 结果
     */
    @Override
    public int insertBzscCyglqglscMbzb(BzscCyglqglscMbzb bzscCyglqglscMbzb)
    {
        bzscCyglqglscMbzb.setCreateTime(DateUtils.getNowDate());
        bzscCyglqglscMbzb.setCreateBy(SecurityUtils.getUsername());
        return bzscCyglqglscMbzbMapper.insertBzscCyglqglscMbzb(bzscCyglqglscMbzb);
    }

    /**
     * 修改标准手册-采油管理区管理手册-模板主
     *
     * @param bzscCyglqglscMbzb 标准手册-采油管理区管理手册-模板主
     * @return 结果
     */
    @Override
    public int updateBzscCyglqglscMbzb(BzscCyglqglscMbzb bzscCyglqglscMbzb)
    {
        bzscCyglqglscMbzb.setUpdateTime(DateUtils.getNowDate());
        bzscCyglqglscMbzb.setUpdateBy(SecurityUtils.getUsername());
        return bzscCyglqglscMbzbMapper.updateBzscCyglqglscMbzb(bzscCyglqglscMbzb);
    }

    /**
     * 批量删除标准手册-采油管理区管理手册-模板主
     *
     * @param IDs 需要删除的标准手册-采油管理区管理手册-模板主主键
     * @return 结果
     */
    @Override
    public int deleteBzscCyglqglscMbzbByIDs(Long[] IDs)
    {
        return bzscCyglqglscMbzbMapper.deleteBzscCyglqglscMbzbByIDs(IDs);
    }

    /**
     * 删除标准手册-采油管理区管理手册-模板主信息
     *
     * @param ID 标准手册-采油管理区管理手册-模板主主键
     * @return 结果
     */
    @Override
    public int deleteBzscCyglqglscMbzbByID(Long ID)
    {
        return bzscCyglqglscMbzbMapper.deleteBzscCyglqglscMbzbByID(ID);
    }
}
