package com.qianhe.bzsc.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.bzsc.domain.BzscCyglqglscMbcb;
import com.qianhe.bzsc.service.IBzscCyglqglscMbcbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-采油管理区管理手册-模板从Controller
 *
 * @author qianhe
 * @date 2024-11-11
 */
@RestController
@RequestMapping("/bzsc/bzscCyglqglscMbcb")
public class BzscCyglqglscMbcbController extends BaseController
{
    @Autowired
    private IBzscCyglqglscMbcbService bzscCyglqglscMbcbService;

    /**
     * 查询标准手册-采油管理区管理手册-模板从列表
     */
    @GetMapping("/list")
    public TableDataInfo list(BzscCyglqglscMbcb bzscCyglqglscMbcb)
    {
        List<BzscCyglqglscMbcb> list = bzscCyglqglscMbcbService.selectBzscCyglqglscMbcbList(bzscCyglqglscMbcb);
        return getDataTable(list);
    }

    @GetMapping("/list_byzbId")
    public TableDataInfo list(Long zbId)
    {
        List<BzscCyglqglscMbcb> list = bzscCyglqglscMbcbService.selectBzscCyglqglscMbcbList_ByZbid(zbId);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-采油管理区管理手册-模板从列表
     */
    @Log(title = "标准手册-采油管理区管理手册-模板从", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscCyglqglscMbcb bzscCyglqglscMbcb)
    {
        List<BzscCyglqglscMbcb> list = bzscCyglqglscMbcbService.selectBzscCyglqglscMbcbList(bzscCyglqglscMbcb);
        ExcelUtil<BzscCyglqglscMbcb> util = new ExcelUtil<BzscCyglqglscMbcb>(BzscCyglqglscMbcb.class);
        util.exportExcel(response, list, "标准手册-采油管理区管理手册-模板从数据");
    }

    /**
     * 获取标准手册-采油管理区管理手册-模板从详细信息
     */
    @GetMapping(value = "/{ID}")
    public AjaxResult getInfo(@PathVariable("ID") Long ID)
    {
        return success(bzscCyglqglscMbcbService.selectBzscCyglqglscMbcbByID(ID));
    }

    /**
     * 新增标准手册-采油管理区管理手册-模板从
     */
    @Log(title = "标准手册-采油管理区管理手册-模板从", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscCyglqglscMbcb bzscCyglqglscMbcb)
    {
        return toAjax(bzscCyglqglscMbcbService.insertBzscCyglqglscMbcb(bzscCyglqglscMbcb));
    }

    /**
     * 修改标准手册-采油管理区管理手册-模板从
     */
    @Log(title = "标准手册-采油管理区管理手册-模板从", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscCyglqglscMbcb bzscCyglqglscMbcb)
    {
        return toAjax(bzscCyglqglscMbcbService.updateBzscCyglqglscMbcb(bzscCyglqglscMbcb));
    }

    /**
     * 删除标准手册-采油管理区管理手册-模板从
     */
    @Log(title = "标准手册-采油管理区管理手册-模板从", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ID}")
    public AjaxResult remove(@PathVariable Long ID)
    {
        if (bzscCyglqglscMbcbService.hasChildByID(ID))
        {
            return warn("存在子内容,不允许删除");
        }
        return toAjax(bzscCyglqglscMbcbService.deleteBzscCyglqglscMbcbByID(ID));
    }
}
