package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.domain.SjGfjsZsdwwtcj;
import com.qianhe.mapper.SjGfjsZsdwwtcjMapper;
import com.qianhe.service.ISjGfjsZsdwwtcjService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 规范建设-直属单位问题采集Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-23
 */
@Service
public class SjGfjsZsdwwtcjServiceImpl implements ISjGfjsZsdwwtcjService
{
    @Autowired
    private SjGfjsZsdwwtcjMapper sjGfjsZsdwwtcjMapper;

    /**
     * 查询规范建设-直属单位问题采集
     *
     * @param id 规范建设-直属单位问题采集主键
     * @return 规范建设-直属单位问题采集
     */
    @Override
    public SjGfjsZsdwwtcj selectSjGfjsZsdwwtcjById(Long id)
    {
        SjGfjsZsdwwtcj zsdwwtcj = sjGfjsZsdwwtcjMapper.selectSjGfjsZsdwwtcjById(id);
        return zsdwwtcj;
    }

    /**
     * 查询规范建设-直属单位问题采集列表
     *
     * @param sjGfjsZsdwwtcj 规范建设-直属单位问题采集
     * @return 规范建设-直属单位问题采集
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjGfjsZsdwwtcj> selectSjGfjsZsdwwtcjList(SjGfjsZsdwwtcj sjGfjsZsdwwtcj)
    {
        sjGfjsZsdwwtcj.setJcjb("直属单位自查");
        return sjGfjsZsdwwtcjMapper.selectSjGfjsZsdwwtcjList(sjGfjsZsdwwtcj);
    }

    /**
     * 新增规范建设-直属单位问题采集
     *
     * @param sjGfjsZsdwwtcj 规范建设-直属单位问题采集
     * @return 结果
     */
    @Override
    public int insertSjGfjsZsdwwtcj(SjGfjsZsdwwtcj sjGfjsZsdwwtcj)
    {
        sjGfjsZsdwwtcj.setCreateTime(DateUtils.getNowDate());
        sjGfjsZsdwwtcj.setCreateBy(SecurityUtils.getUsername());
        return sjGfjsZsdwwtcjMapper.insertSjGfjsZsdwwtcj(sjGfjsZsdwwtcj);
    }

    /**
     * 修改规范建设-直属单位问题采集
     *
     * @param sjGfjsZsdwwtcj 规范建设-直属单位问题采集
     * @return 结果
     */
    @Override
    public int updateSjGfjsZsdwwtcj(SjGfjsZsdwwtcj sjGfjsZsdwwtcj)
    {
        sjGfjsZsdwwtcj.setUpdateTime(DateUtils.getNowDate());
        sjGfjsZsdwwtcj.setUpdateBy(SecurityUtils.getUsername());
        return sjGfjsZsdwwtcjMapper.updateSjGfjsZsdwwtcj(sjGfjsZsdwwtcj);
    }
    @Override
    public int plxg(SjGfjsZsdwwtcj sjGfjsZsdwwtcj)
    {
        sjGfjsZsdwwtcj.setUpdateTime(DateUtils.getNowDate());
        sjGfjsZsdwwtcj.setUpdateBy(SecurityUtils.getUsername());
        return sjGfjsZsdwwtcjMapper.plxg(sjGfjsZsdwwtcj);
    }

    /**
     * 批量删除规范建设-直属单位问题采集
     *
     * @param ids 需要删除的规范建设-直属单位问题采集主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwwtcjByIds(Long[] ids)
    {
        return sjGfjsZsdwwtcjMapper.deleteSjGfjsZsdwwtcjByIds(ids);
    }

    /**
     * 删除规范建设-直属单位问题采集信息
     *
     * @param id 规范建设-直属单位问题采集主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsZsdwwtcjById(Long id)
    {
        return sjGfjsZsdwwtcjMapper.deleteSjGfjsZsdwwtcjById(id);
    }

    @Override
    public int batchSave(List<SjGfjsZsdwwtcj> list) {
        return sjGfjsZsdwwtcjMapper.batchSave(list);
    }
}
