package com.qianhe.domain;

import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.poi.ss.usermodel.IndexedColors;

/**
 * 规范建设-直属单位考核评价否决项对象 sj_gfjs_zsdwkhpjfjx
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Data
public class SjGfjsZsdwkhpjfjx extends BaseEntity
{
    private static final long serialVersionUID = 1L;


    @Excel(name = "单位名称）")
    private String deptName;
    /** 年度 */
    @Excel(name = "年度")
    private String nd;

    /** 周期范围（第一季度-第四季度、上半年、下半年） */
    @Excel(name = "周期范围")
    private String zqfw;

    /** 周期类型（季度、半年度、年度） */
//    @Excel(name = "周期类型", readConverterExp = "季=度、半年度、年度")
    private String zqlx;

    /** 级别（直属单位（半年度）、基层单位（季度）、三基帮扶组（年度）） */
//    @Excel(name = "级别", readConverterExp = "直=属单位（半年度")
    private String jb;

    /** 分类名称 */
    @Excel(name = "分类名称")
    private String flmc;


    /** 评价标准名称 */
    @Excel(name = "评价标准")
    private String pjbzmc;

    /** 是否发生 */
    @Excel(name = "是否发生")
    private String sffs;

    /** 问题描述 */
    @Excel(name = "亮点与问题")
    private String wtms;

    /** 预留1 */
//    @Excel(name = "预留1")
    private Long yl1;

    /** 预留2 */
//    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
//    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
//    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
//    @Excel(name = "预留5")
    private String yl5;



    /** 主键 */
    @Excel(name = "id（勿动）",headerColor = IndexedColors.RED1)
    private Long id;

    /** 主表id */
    @Excel(name = "主表id（勿动）",headerColor = IndexedColors.RED1)
    private Long zbId;

    /** 单位id */
    @Excel(name = "单位id（勿动）",headerColor = IndexedColors.RED1)
    private Long deptId;
    /** 评价标准id */
    @Excel(name = "评价标准id")
    private String pjbzid;

}
