package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.BzscYsjglggzscfj;
import com.qianhe.service.IBzscYsjglggzscfjService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 标准手册-油水井管理岗工作手册附件Controller
 *
 * @author qianhe
 * @date 2024-10-09
 */
@RestController
@RequestMapping("/system/ysjglggzscfj")
public class BzscYsjglggzscfjController extends BaseController
{
    @Autowired
    private IBzscYsjglggzscfjService bzscYsjglggzscfjService;

    /**
     * 查询标准手册-油水井管理岗工作手册附件列表
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzscfj:list')")
    @GetMapping("/list")
    public TableDataInfo list(BzscYsjglggzscfj bzscYsjglggzscfj)
    {
        startPage();
        List<BzscYsjglggzscfj> list = bzscYsjglggzscfjService.selectBzscYsjglggzscfjList(bzscYsjglggzscfj);
        return getDataTable(list);
    }

    /**
     * 导出标准手册-油水井管理岗工作手册附件列表
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzscfj:export')")
    @Log(title = "标准手册-油水井管理岗工作手册附件", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, BzscYsjglggzscfj bzscYsjglggzscfj)
    {
        List<BzscYsjglggzscfj> list = bzscYsjglggzscfjService.selectBzscYsjglggzscfjList(bzscYsjglggzscfj);
        ExcelUtil<BzscYsjglggzscfj> util = new ExcelUtil<BzscYsjglggzscfj>(BzscYsjglggzscfj.class);
        util.exportExcel(response, list, "标准手册-油水井管理岗工作手册附件数据");
    }

    /**
     * 获取标准手册-油水井管理岗工作手册附件详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzscfj:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(bzscYsjglggzscfjService.selectBzscYsjglggzscfjById(id));
    }

    /**
     * 新增标准手册-油水井管理岗工作手册附件
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzscfj:add')")
    @Log(title = "标准手册-油水井管理岗工作手册附件", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BzscYsjglggzscfj bzscYsjglggzscfj)
    {
        return toAjax(bzscYsjglggzscfjService.insertBzscYsjglggzscfj(bzscYsjglggzscfj));
    }

    /**
     * 修改标准手册-油水井管理岗工作手册附件
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzscfj:edit')")
    @Log(title = "标准手册-油水井管理岗工作手册附件", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BzscYsjglggzscfj bzscYsjglggzscfj)
    {
        return toAjax(bzscYsjglggzscfjService.updateBzscYsjglggzscfj(bzscYsjglggzscfj));
    }

    /**
     * 删除标准手册-油水井管理岗工作手册附件
     */
    @PreAuthorize("@ss.hasPermi('system:ysjglggzscfj:remove')")
    @Log(title = "标准手册-油水井管理岗工作手册附件", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(bzscYsjglggzscfjService.deleteBzscYsjglggzscfjByIds(ids));
    }
}
