package com.qianhe.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.domain.SjGfjsZdgz;
import com.qianhe.domain.SjGfjsZdgzCb;
import com.qianhe.service.ISjGfjsZdgzService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 规范建设-重点工作 原考核评价标准Controller
 *
 * @author qianhe
 * @date 2024-07-22
 */
@RestController
@RequestMapping("/system/sjGfjsZdgz")
public class SjGfjsZdgzController extends BaseController
{
    @Autowired
    private ISjGfjsZdgzService sjGfjsZdgzService;

    /**
     * 查询规范建设-重点工作 原考核评价标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsZdgz:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjGfjsZdgz sjGfjsZdgz)
    {
        startPage();
        List<SjGfjsZdgz> list = sjGfjsZdgzService.selectSjGfjsZdgzList(sjGfjsZdgz);
        return getDataTable(list);
    }


    /**
     * 查询规范建设-重点工作 原考核评价标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsZdgz:cxlist')")
    @GetMapping("/cxlist")
    public TableDataInfo cxlist(SjGfjsZdgz sjGfjsZdgz)
    {
//        startPage();
        List<SjGfjsZdgz> list = sjGfjsZdgzService.selectSjGfjsZdgzCxList(sjGfjsZdgz);
        return getDataTable(list);
    }

    /**
     * 导出规范建设-重点工作 原考核评价标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsZdgz:export')")
    @Log(title = "规范建设-重点工作 原考核评价标准", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsZdgz sjGfjsZdgz)
    {
        List<SjGfjsZdgz> list = sjGfjsZdgzService.selectSjGfjsZdgzList(sjGfjsZdgz);
        ExcelUtil<SjGfjsZdgz> util = new ExcelUtil<SjGfjsZdgz>(SjGfjsZdgz.class);
        util.exportExcel(response, list, "规范建设-重点工作 原考核评价标准数据");
    }

    /**
     * 获取规范建设-重点工作 原考核评价标准详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsZdgz:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsZdgzService.selectSjGfjsZdgzById(id));
    }

    /**
     * 新增规范建设-重点工作 原考核评价标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsZdgz:add')")
    @Log(title = "规范建设-重点工作 原考核评价标准", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsZdgz sjGfjsZdgz)
    {
        return toAjax(sjGfjsZdgzService.insertSjGfjsZdgz(sjGfjsZdgz));
    }

    /**
     * 修改规范建设-重点工作 原考核评价标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsZdgz:edit')")
    @Log(title = "规范建设-重点工作 原考核评价标准", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsZdgz sjGfjsZdgz)
    {
        return toAjax(sjGfjsZdgzService.updateSjGfjsZdgz(sjGfjsZdgz));
    }

    /**
     * 删除规范建设-重点工作 原考核评价标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsZdgz:remove')")
    @Log(title = "规范建设-重点工作 原考核评价标准", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsZdgzService.deleteSjGfjsZdgzByIds(ids));
    }

    /**
     * 查询考核内容集合
     * @param cb
     * @return
     */
    @GetMapping("/getKhnrList")
    public AjaxResult getKhnrList(SjGfjsZdgzCb cb){

        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
//        if(StringUtils.isEmpty(cb.getLx())){
//            return AjaxResult.error("该单位未设置类型");
//        }
        cb.setLx("基础");
        List<String> khnrList = sjGfjsZdgzService.getKhnrList(cb);
        return success(khnrList);
    }


    /**
     * 查询考核项点集合
     * @param cb
     * @return
     */
    @GetMapping("/getKhxdList")
    public AjaxResult getKhxdList(SjGfjsZdgzCb cb){
        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        cb.setLx("基础");
        List<String> rl = sjGfjsZdgzService.getKhxdList(cb);
        rl.add("其他");//统一加其他
        return success(rl);
    }

    /**
     * 查询考核项点集合
     * @param cb
     * @return
     */
    @GetMapping("/getPjbzList")
    public AjaxResult getPjbzList(SjGfjsZdgzCb cb){
        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        cb.setLx("基础");
        return success(sjGfjsZdgzService.getPjbzList(cb));
    }


    /**
     * 修改规范建设-重点工作 原考核评价标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjGfjsZdgz:edit')")
    @Log(title = "规范建设-重点工作 原考核评价标准", businessType = BusinessType.UPDATE)
    @PutMapping("/editQzxs")
    public AjaxResult editQzxs(@RequestBody SjGfjsZdgz sjGfjsZdgz)
    {
        return toAjax(sjGfjsZdgzService.updateSjGfjsZdgz_QZXS(sjGfjsZdgz));
    }

}
