package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.system.domain.SysUserRole;
import com.qianhe.system.mapper.SysUserRoleMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjGfjsLbzdbfMapper;
import com.qianhe.domain.SjGfjsLbzdbf;
import com.qianhe.service.ISjGfjsLbzdbfService;

/**
 * 规范建设-练兵指导帮扶Service业务层处理
 *
 * @author qianhe
 * @date 2025-08-19
 */
@Service
public class SjGfjsLbzdbfServiceImpl implements ISjGfjsLbzdbfService
{
    @Autowired
    private SjGfjsLbzdbfMapper sjGfjsLbzdbfMapper;

    /**
     * 查询规范建设-练兵指导帮扶
     *
     * @param id 规范建设-练兵指导帮扶主键
     * @return 规范建设-练兵指导帮扶
     */
    @Override
    public SjGfjsLbzdbf selectSjGfjsLbzdbfById(Long id)
    {
        return sjGfjsLbzdbfMapper.selectSjGfjsLbzdbfById(id);
    }

    /**
     * 查询规范建设-练兵指导帮扶列表
     *
     * @param sjGfjsLbzdbf 规范建设-练兵指导帮扶
     * @return 规范建设-练兵指导帮扶
     */
    @Override
    public List<SjGfjsLbzdbf> selectSjGfjsLbzdbfList(SjGfjsLbzdbf sjGfjsLbzdbf)
    {
        return sjGfjsLbzdbfMapper.selectSjGfjsLbzdbfList(sjGfjsLbzdbf);
    }

    /**
     * 新增规范建设-练兵指导帮扶
     *
     * @param sjGfjsLbzdbf 规范建设-练兵指导帮扶
     * @return 结果
     */
    @Autowired
    private SysUserRoleMapper userRoleMapper;
    @Override
    public int insertSjGfjsLbzdbf(SjGfjsLbzdbf sjGfjsLbzdbf)
    {
        // 给联系人一个帮扶组角色
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sjGfjsLbzdbf.getLxr());
        userRole.setRoleId(new Long(106));
        userRoleMapper.deleteUserRoleInfo(userRole);
        userRoleMapper.insertUserRole(userRole);

        sjGfjsLbzdbf.setCreateTime(DateUtils.getNowDate());
        sjGfjsLbzdbf.setCreateBy(SecurityUtils.getUsername());
        return sjGfjsLbzdbfMapper.insertSjGfjsLbzdbf(sjGfjsLbzdbf);
    }

    /**
     * 修改规范建设-练兵指导帮扶
     *
     * @param sjGfjsLbzdbf 规范建设-练兵指导帮扶
     * @return 结果
     */
    @Override
    public int updateSjGfjsLbzdbf(SjGfjsLbzdbf sjGfjsLbzdbf)
    {
        // 给联系人一个帮扶组角色
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sjGfjsLbzdbf.getLxr());
        userRole.setRoleId(new Long(106));
        userRoleMapper.deleteUserRoleInfo(userRole);
        userRoleMapper.insertUserRole(userRole);

        sjGfjsLbzdbf.setUpdateTime(DateUtils.getNowDate());
        sjGfjsLbzdbf.setUpdateBy(SecurityUtils.getUsername());
        return sjGfjsLbzdbfMapper.updateSjGfjsLbzdbf(sjGfjsLbzdbf);
    }

    /**
     * 批量删除规范建设-练兵指导帮扶
     *
     * @param ids 需要删除的规范建设-练兵指导帮扶主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsLbzdbfByIds(Long[] ids)
    {
        return sjGfjsLbzdbfMapper.deleteSjGfjsLbzdbfByIds(ids);
    }

    /**
     * 删除规范建设-练兵指导帮扶信息
     *
     * @param id 规范建设-练兵指导帮扶主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsLbzdbfById(Long id)
    {
        return sjGfjsLbzdbfMapper.deleteSjGfjsLbzdbfById(id);
    }
}
