package com.qianhe.service.impl;

import java.util.List;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.SjBzxxMapper;
import com.qianhe.domain.SjBzxx;
import com.qianhe.service.ISjBzxxService;

/**
 * 班组信息Service业务层处理
 *
 * @author qianhe
 * @date 2025-08-04
 */
@Service
public class SjBzxxServiceImpl implements ISjBzxxService
{
    @Autowired
    private SjBzxxMapper sjBzxxMapper;

    /**
     * 查询班组信息
     *
     * @param id 班组信息主键
     * @return 班组信息
     */
    @Override
    public SjBzxx selectSjBzxxById(Long id)
    {
        return sjBzxxMapper.selectSjBzxxById(id);
    }

    /**
     * 查询班组信息列表
     *
     * @param sjBzxx 班组信息
     * @return 班组信息
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjBzxx> selectSjBzxxList(SjBzxx sjBzxx)
    {
        return sjBzxxMapper.selectSjBzxxList(sjBzxx);
    }

    /**
     * 新增班组信息
     *
     * @param sjBzxx 班组信息
     * @return 结果
     */
    @Override
    public int insertSjBzxx(SjBzxx sjBzxx)
    {
        sjBzxx.setCreateBy(SecurityUtils.getUsername());
        sjBzxx.setCreateTime(DateUtils.getNowDate());
        return sjBzxxMapper.insertSjBzxx(sjBzxx);
    }

    /**
     * 修改班组信息
     *
     * @param sjBzxx 班组信息
     * @return 结果
     */
    @Override
    public int updateSjBzxx(SjBzxx sjBzxx)
    {
        sjBzxx.setUpdateBy(SecurityUtils.getUsername());
        sjBzxx.setUpdateTime(DateUtils.getNowDate());
        return sjBzxxMapper.updateSjBzxx(sjBzxx);
    }

    /**
     * 批量删除班组信息
     *
     * @param ids 需要删除的班组信息主键
     * @return 结果
     */
    @Override
    public int deleteSjBzxxByIds(Long[] ids)
    {
        return sjBzxxMapper.deleteSjBzxxByIds(ids);
    }

    /**
     * 删除班组信息信息
     *
     * @param id 班组信息主键
     * @return 结果
     */
    @Override
    public int deleteSjBzxxById(Long id)
    {
        return sjBzxxMapper.deleteSjBzxxById(id);
    }





    @Override
    @DataScope(deptAlias = "d")
    public SjBzxx selectBzxxTj(SjBzxx sjBzxx)
    {
        return sjBzxxMapper.selectBzxxTj(sjBzxx);
    }
    @Override
    public int pltj(SjBzxx sjBzxx)
    {
        sjBzxx.setUpdateBy(SecurityUtils.getUsername());
        sjBzxx.setUpdateTime(DateUtils.getNowDate());
        return sjBzxxMapper.plxg(sjBzxx);
    }


}
