package com.qianhe.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson2.JSON;
import com.qianhe.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.GgFjbMapper;
import com.qianhe.domain.GgFjb;
import com.qianhe.service.IGgFjbService;

/**
 * 公共附件Service业务层处理
 *
 * @author qianhe
 * @date 2025-08-04
 */
@Service
public class GgFjbServiceImpl implements IGgFjbService
{
    @Autowired
    private GgFjbMapper ggFjbMapper;

    /**
     * 查询公共附件
     *
     * @param ID 公共附件主键
     * @return 公共附件
     */
    @Override
    public GgFjb selectGgFjbByID(Long ID)
    {
        return ggFjbMapper.selectGgFjbByID(ID);
    }

    /**
     * 查询公共附件列表
     *
     * @param ggFjb 公共附件
     * @return 公共附件
     */
    @Override
    public List<GgFjb> selectGgFjbList(GgFjb ggFjb)
    {
        return ggFjbMapper.selectGgFjbList(ggFjb);
    }

    /**
     * 新增公共附件
     *
     * @param ggFjb 公共附件
     * @return 结果
     */
    @Override
    public int insertGgFjb(GgFjb ggFjb)
    {
        return ggFjbMapper.insertGgFjb(ggFjb);
    }

    /**
     * 修改公共附件
     *
     * @param ggFjb 公共附件
     * @return 结果
     */
    @Override
    public int updateGgFjb(GgFjb ggFjb)
    {
        return ggFjbMapper.updateGgFjb(ggFjb);
    }

    /**
     * 批量删除公共附件
     *
     * @param IDs 需要删除的公共附件主键
     * @return 结果
     */
    @Override
    public int deleteGgFjbByIDs(Long[] IDs)
    {
        return ggFjbMapper.deleteGgFjbByIDs(IDs);
    }

    /**
     * 删除公共附件信息
     *
     * @param ID 公共附件主键
     * @return 结果
     */
    @Override
    public int deleteGgFjbByID(Long ID)
    {
        return ggFjbMapper.deleteGgFjbByID(ID);
    }



    @Override
    public int batchSaveFj(String businessId, String fjlx, String mkmc, String fileListStr)
    {
        int i2 = 0;
        if(fileListStr != null && fileListStr.length()>0){

            List<GgFjb> fileList = JSON.parseArray(fileListStr, GgFjb.class);
            GgFjb map = new GgFjb();
            map.setYWID(businessId);
            map.setFJLX(fjlx);
            map.setMKMC(mkmc);
            ggFjbMapper.deleteFjByYwid(map);//修改保存前先删除附件表

            for(int i=0;i<fileList.size();i++){
                GgFjb file = fileList.get(i);
                String name = file.getFJMC();
                String fileName = file.getFJDZ();
                GgFjb infj = new GgFjb();
                infj.setFJMC(name);
                infj.setFJDZ(fileName);
                infj.setFJLX(fjlx);
                infj.setMKMC(mkmc);
                infj.setCJR(SecurityUtils.getLoginUser().getUsername());
                infj.setYWID(businessId);
                infj.setCJSJ(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                i2 = i2 + ggFjbMapper.insertFj(infj);
            }
        }
        return i2;
    }
    @Override
    public List<GgFjb> selectFj(Long id, String mkmc) {
        return ggFjbMapper.selectFj(id,mkmc);
    }
    @Override
    public List<GgFjb> selectFjByMk(String mkmc) {
        return ggFjbMapper.selectFjByMk(mkmc);
    }
    @Override
    public int deleteFjByYwid(GgFjb fj) {
        return ggFjbMapper.deleteFjByYwid(fj);
    }


}
