package com.qianhe.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 文档-类型维护对象 wd_lxwh
 *
 * @author qianhe
 * @date 2024-02-28
 */
public class WdLxwh extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 类型名称 */
    @Excel(name = "类型名称")
    private String name;

    /** 录入人 */
    @Excel(name = "录入人")
    private String lrr;

    /** 录入时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "录入时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date lrsj;

    /** 修改人 */
    @Excel(name = "修改人")
    private String xgr;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "修改时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date xgsj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setName(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return name;
    }
    public void setLrr(String lrr)
    {
        this.lrr = lrr;
    }

    public String getLrr()
    {
        return lrr;
    }
    public void setLrsj(Date lrsj)
    {
        this.lrsj = lrsj;
    }

    public Date getLrsj()
    {
        return lrsj;
    }
    public void setXgr(String xgr)
    {
        this.xgr = xgr;
    }

    public String getXgr()
    {
        return xgr;
    }
    public void setXgsj(Date xgsj)
    {
        this.xgsj = xgsj;
    }

    public Date getXgsj()
    {
        return xgsj;
    }
    public void setBz(String bz)
    {
        this.bz = bz;
    }

    public String getBz()
    {
        return bz;
    }
    public void setYl1(String yl1)
    {
        this.yl1 = yl1;
    }

    public String getYl1()
    {
        return yl1;
    }
    public void setYl2(String yl2)
    {
        this.yl2 = yl2;
    }

    public String getYl2()
    {
        return yl2;
    }
    public void setYl3(String yl3)
    {
        this.yl3 = yl3;
    }

    public String getYl3()
    {
        return yl3;
    }
    public void setYl4(String yl4)
    {
        this.yl4 = yl4;
    }

    public String getYl4()
    {
        return yl4;
    }
    public void setYl5(String yl5)
    {
        this.yl5 = yl5;
    }

    public String getYl5()
    {
        return yl5;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("lrr", getLrr())
            .append("lrsj", getLrsj())
            .append("xgr", getXgr())
            .append("xgsj", getXgsj())
            .append("bz", getBz())
            .append("yl1", getYl1())
            .append("yl2", getYl2())
            .append("yl3", getYl3())
            .append("yl4", getYl4())
            .append("yl5", getYl5())
            .toString();
    }
}
