package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjGfjsFdgz;
import com.qianhe.service.ISjGfjsFdgzService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 单位分档规则Controller
 *
 * @author qianhe
 * @date 2025-08-15
 */
@RestController
@RequestMapping("/system/SjGfjsFdgz")
public class SjGfjsFdgzController extends BaseController
{
    @Autowired
    private ISjGfjsFdgzService sjGfjsFdgzService;

    /**
     * 查询单位分档规则列表
     */

    @GetMapping("/list")
    public TableDataInfo list(SjGfjsFdgz sjGfjsFdgz)
    {
        startPage();
        List<SjGfjsFdgz> list = sjGfjsFdgzService.selectSjGfjsFdgzList(sjGfjsFdgz);
        return getDataTable(list);
    }

    /**
     * 导出单位分档规则列表
     */

    @Log(title = "单位分档规则", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsFdgz sjGfjsFdgz)
    {
        List<SjGfjsFdgz> list = sjGfjsFdgzService.selectSjGfjsFdgzList(sjGfjsFdgz);
        ExcelUtil<SjGfjsFdgz> util = new ExcelUtil<SjGfjsFdgz>(SjGfjsFdgz.class);
        util.exportExcel(response, list, "单位分档规则数据");
    }

    /**
     * 获取单位分档规则详细信息
     */

    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsFdgzService.selectSjGfjsFdgzById(id));
    }

    /**
     * 新增单位分档规则
     */

    @Log(title = "单位分档规则", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsFdgz sjGfjsFdgz)
    {
        return toAjax(sjGfjsFdgzService.insertSjGfjsFdgz(sjGfjsFdgz));
    }

    /**
     * 修改单位分档规则
     */

    @Log(title = "单位分档规则", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsFdgz sjGfjsFdgz)
    {
        return toAjax(sjGfjsFdgzService.updateSjGfjsFdgz(sjGfjsFdgz));
    }

    /**
     * 删除单位分档规则
     */

    @Log(title = "单位分档规则", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsFdgzService.deleteSjGfjsFdgzByIds(ids));
    }
}
