package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjGfjsDxjcz;
import com.qianhe.service.ISjGfjsDxjczService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 单项基础值Controller
 *
 * @author qianhe
 * @date 2025-08-15
 */
@RestController
@RequestMapping("/system/SjGfjsDxjcz")
public class SjGfjsDxjczController extends BaseController
{
    @Autowired
    private ISjGfjsDxjczService sjGfjsDxjczService;

    /**
     * 查询单项基础值列表
     */

    @GetMapping("/list")
    public TableDataInfo list(SjGfjsDxjcz sjGfjsDxjcz)
    {
        startPage();
        List<SjGfjsDxjcz> list = sjGfjsDxjczService.selectSjGfjsDxjczList(sjGfjsDxjcz);
        return getDataTable(list);
    }

    /**
     * 导出单项基础值列表
     */

    @Log(title = "单项基础值", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsDxjcz sjGfjsDxjcz)
    {
        List<SjGfjsDxjcz> list = sjGfjsDxjczService.selectSjGfjsDxjczList(sjGfjsDxjcz);
        ExcelUtil<SjGfjsDxjcz> util = new ExcelUtil<SjGfjsDxjcz>(SjGfjsDxjcz.class);
        util.exportExcel(response, list, "单项基础值数据");
    }

    /**
     * 获取单项基础值详细信息
     */

    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsDxjczService.selectSjGfjsDxjczById(id));
    }

    /**
     * 新增单项基础值
     */

    @Log(title = "单项基础值", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsDxjcz sjGfjsDxjcz)
    {
        return toAjax(sjGfjsDxjczService.insertSjGfjsDxjcz(sjGfjsDxjcz));
    }

    /**
     * 修改单项基础值
     */

    @Log(title = "单项基础值", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsDxjcz sjGfjsDxjcz)
    {
        return toAjax(sjGfjsDxjczService.updateSjGfjsDxjcz(sjGfjsDxjcz));
    }

    /**
     * 删除单项基础值
     */

    @Log(title = "单项基础值", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsDxjczService.deleteSjGfjsDxjczByIds(ids));
    }
}
