package com.qianhe.web.controller.common;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.bean.BeanUtils;
import com.qianhe.domain.BzscYsjglggzscfj;
import com.qianhe.domain.WdWdxxRd;
import com.qianhe.mapper.BzscYsjglggzscfjMapper;
import com.qianhe.mapper.WdWdxxRdMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import com.qianhe.common.config.RuoYiConfig;
import com.qianhe.common.constant.Constants;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.common.utils.file.FileUploadUtils;
import com.qianhe.common.utils.file.FileUtils;
import com.qianhe.framework.config.ServerConfig;

/**
 * 通用请求处理
 *
 * @author qinahe
 */
@RestController
@RequestMapping("/common")
public class CommonController
{
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);

    @Autowired
    private ServerConfig serverConfig;
    @Autowired
    private WdWdxxRdMapper wdWdxxRdMapper;
    @Autowired

    private BzscYsjglggzscfjMapper bzscYsjglggzscfjMapper;

    private static final String FILE_DELIMETER = ",";

    /**
     * 通用下载请求
     *
     * @param fileName 文件名称
     * @param delete 是否删除
     */
    @GetMapping("/download")
    public void fileDownload(String fileName, Boolean delete, HttpServletResponse response, HttpServletRequest request)
    {
        try
        {
            if (!FileUtils.checkAllowDownload(fileName))
            {
                throw new Exception(StringUtils.format("文件名称({})非法，不允许下载。 ", fileName));
            }
            String realFileName = System.currentTimeMillis() + fileName.substring(fileName.indexOf("_") + 1);
            String localPath = RuoYiConfig.getProfile();
//            // 数据库资源地址
            String filePath = localPath + StringUtils.substringAfter(fileName, Constants.RESOURCE_PREFIX);
//            String downloadPath = RuoYiConfig.getDownloadPath();
//            String filePath = downloadPath + fileName;

            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            FileUtils.setAttachmentResponseHeader(response, realFileName);
            FileUtils.writeBytes(filePath, response.getOutputStream());
            if (delete)
            {
                FileUtils.deleteFile(filePath);
            }
        }
        catch (Exception e)
        {
            log.error("下载文件失败", e);
        }
    }

    /**
     * 通用上传请求（单个）
     */
    @PostMapping("/upload")
    public AjaxResult uploadFile(MultipartFile file) throws Exception
    {
        try
        {
            // 上传文件路径
            String filePath = RuoYiConfig.getUploadPath();
            // 上传并返回新文件名称
            String fileName = FileUploadUtils.upload(filePath, file);
            String url = serverConfig.getUrl() + fileName;
            AjaxResult ajax = AjaxResult.success();
            ajax.put("url", url);
            ajax.put("fileName", fileName);
            ajax.put("newFileName", FileUtils.getName(fileName));
            ajax.put("originalFilename", file.getOriginalFilename());
            return ajax;
        }
        catch (Exception e)
        {
            return AjaxResult.error(e.getMessage());
        }
    }

    /**
     * 通用上传请求（多个）
     */
    @PostMapping("/uploads")
    public AjaxResult uploadFiles(List<MultipartFile> files) throws Exception
    {
        try
        {
            // 上传文件路径
            String filePath = RuoYiConfig.getUploadPath();
            List<String> urls = new ArrayList<String>();
            List<String> fileNames = new ArrayList<String>();
            List<String> newFileNames = new ArrayList<String>();
            List<String> originalFilenames = new ArrayList<String>();
            for (MultipartFile file : files)
            {
                // 上传并返回新文件名称
                String fileName = FileUploadUtils.upload(filePath, file);
                String url = serverConfig.getUrl() + fileName;
                urls.add(url);
                fileNames.add(fileName);
                newFileNames.add(FileUtils.getName(fileName));
                originalFilenames.add(file.getOriginalFilename());
            }
            AjaxResult ajax = AjaxResult.success();
            ajax.put("urls", StringUtils.join(urls, FILE_DELIMETER));
            ajax.put("fileNames", StringUtils.join(fileNames, FILE_DELIMETER));
            ajax.put("newFileNames", StringUtils.join(newFileNames, FILE_DELIMETER));
            ajax.put("originalFilenames", StringUtils.join(originalFilenames, FILE_DELIMETER));
            return ajax;
        }
        catch (Exception e)
        {
            return AjaxResult.error(e.getMessage());
        }
    }


    /**
     * 通用上传请求（多个）
     */
    @PostMapping("/uploadAll")
    public AjaxResult uploadAll(@RequestParam("file") List<MultipartFile> files,
                                @RequestParam("deptId")String deptId,
                                @RequestParam("nd") String nd,
                                @RequestParam("mkmc") String mkmc,
                                @RequestParam("fjlx") String fjlx,
                                @RequestParam("rdpx")  String rdpx,
                                @RequestParam("yl1")  String yl1) throws Exception
    {
        try
        {
            // 上传文件路径
            String filePath = RuoYiConfig.getUploadPath();
            List<WdWdxxRd> wdWdxxRdList =new ArrayList<>();
//            if(StringUtils.isEmpty(wdWdxxRd.getDeptId())){
//                return AjaxResult.success("");
//            }

//            String param="?deptId="+wdWdxxRd.getDeptId()+"&nd="+wdWdxxRd.getNd()+"&mkmc="+wdWdxxRd.getMkmc()+"&fjlx="+wdWdxxRd.getFjlx()+"&rdpx="+wdWdxxRd.getRdpx();
            String param="?deptId="+deptId+"&nd="+nd+"&mkmc="+mkmc+"&fjlx="+fjlx+"&rdpx="+rdpx+"&yl1="+yl1;
            for (MultipartFile file : files)
            {
//                fileName:"/profile/upload/2024/09/14/1_20240914100039A002.jpg"
//                newFileName:"1_20240914100039A002.jpg"
//                originalFilename:"1.jpg"
//                url:"http://192.168.31.108:8899/profile/upload/2024/09/14/1_20240914100039A002.jpg"
                // 上传并返回新文件名称
                String fileName = FileUploadUtils.upload(filePath, file);
//                String url = serverConfig.getUrl() + fileName;
//                urls.add(url);
//                fileNames.add(fileName);
//                newFileNames.add(FileUtils.getName(fileName));
//                originalFilenames.add(file.getOriginalFilename());
                WdWdxxRd xx=new WdWdxxRd();
                xx.setDeptId(deptId);
                xx.setNd(nd);
                xx.setMkmc(mkmc);
                xx.setFjlx(fjlx);
                xx.setRdpx(rdpx);
                xx.setFjdz(fileName);
                xx.setFjmc(file.getOriginalFilename());
                xx.setLrr(SecurityUtils.getUsername());
                xx.setLrsj(DateUtils.getNowDate());
                xx.setYl1(yl1);
                wdWdxxRdList.add(xx);
            }
            if(wdWdxxRdList.size()>0){
                wdWdxxRdMapper.insertWdWdxxRdBatch(wdWdxxRdList);
            }
            return AjaxResult.success(param);
        }
        catch (Exception e)
        {
            return AjaxResult.error(e.getMessage());
        }
    }


    /**
     * 通用上传请求（多个）
     */
    @PostMapping("/ysjuploadAll")
    public AjaxResult ysjuploadAll(@RequestParam("file") List<MultipartFile> files,
                                @RequestParam("deptId")String deptId,
                                @RequestParam("nd") String nd,
                                @RequestParam("dl") String dl,
                                @RequestParam("zl") String zl,
                                @RequestParam("fjlx") String fjlx,
                                @RequestParam("rdpx")  String rdpx) throws Exception {
        try
        {
            // 上传文件路径
            String filePath = RuoYiConfig.getUploadPath();
            List<BzscYsjglggzscfj> bzscYsjglggzscfjs = new ArrayList<>();
            String param="?deptId="+deptId+"&nd="+nd+"&dl="+dl+"&fjlx="+fjlx+"&rdpx="+rdpx;
            for (MultipartFile file : files)
            {
                // 上传并返回新文件名称
                String fileName = FileUploadUtils.upload(filePath, file);

                BzscYsjglggzscfj xx = new BzscYsjglggzscfj();
                xx.setDeptId(deptId);
                xx.setNd(nd);
                xx.setDl(dl);
                xx.setZl(zl);
                xx.setFjlx(fjlx);
                xx.setRdpx(rdpx);
                xx.setFjdz(fileName);
                xx.setFjmc(file.getOriginalFilename());
                xx.setLrr(SecurityUtils.getUsername());
                xx.setLrsj(DateUtils.getNowDate());
                bzscYsjglggzscfjs.add(xx);
            }
            if(bzscYsjglggzscfjs.size()>0){
                bzscYsjglggzscfjMapper.insertBzscYsjglggzscfjlist(bzscYsjglggzscfjs);
            }
            return AjaxResult.success(param);
        }
        catch (Exception e)
        {
            return AjaxResult.error(e.getMessage());
        }
    }

    /**
     * 本地资源通用下载
     */
//    @GetMapping("/download/resource")
//    public void resourceDownload(String resource, HttpServletRequest request, HttpServletResponse response)
//            throws Exception
//    {
//        try
//        {
//            if (!FileUtils.checkAllowDownload(resource))
//            {
//                throw new Exception(StringUtils.format("资源文件({})非法，不允许下载。 ", resource));
//            }
//            // 本地资源路径
//            String localPath = RuoYiConfig.getProfile();
//            // 数据库资源地址
//            String downloadPath = localPath + StringUtils.substringAfter(resource, Constants.RESOURCE_PREFIX);
//            // 下载名称
//            String downloadName = StringUtils.substringAfterLast(downloadPath, "/");
//            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
//            FileUtils.setAttachmentResponseHeader(response, downloadName);
//            FileUtils.writeBytes(downloadPath, response.getOutputStream());
//        }
//        catch (Exception e)
//        {
//            log.error("下载文件失败", e);
//        }
//    }
}
