package com.qianhe.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.WdWdxxMapper;
import com.qianhe.domain.WdWdxx;
import com.qianhe.service.IWdWdxxService;

/**
 * 文档-文档信息Service业务层处理
 *
 * @author qianhe
 * @date 2024-02-28
 */
@Service
public class WdWdxxServiceImpl implements IWdWdxxService
{
    @Autowired
    private WdWdxxMapper wdWdxxMapper;

    /**
     * 查询文档-文档信息
     *
     * @param id 文档-文档信息主键
     * @return 文档-文档信息
     */
    @Override
    public WdWdxx selectWdWdxxById(Long id)
    {
        return wdWdxxMapper.selectWdWdxxById(id);
    }

    /**
     * 查询文档-文档信息列表
     *
     * @param wdWdxx 文档-文档信息
     * @return 文档-文档信息
     */
    @Override
    public List<WdWdxx> selectWdWdxxList(WdWdxx wdWdxx)
    {
        return wdWdxxMapper.selectWdWdxxList(wdWdxx);
    }

    /**
     * 新增文档-文档信息
     *
     * @param wdWdxx 文档-文档信息
     * @return 结果
     */
    @Override
    public int insertWdWdxx(WdWdxx wdWdxx)
    {
        return wdWdxxMapper.insertWdWdxx(wdWdxx);
    }

    /**
     * 修改文档-文档信息
     *
     * @param wdWdxx 文档-文档信息
     * @return 结果
     */
    @Override
    public int updateWdWdxx(WdWdxx wdWdxx)
    {
        return wdWdxxMapper.updateWdWdxx(wdWdxx);
    }

    /**
     * 批量删除文档-文档信息
     *
     * @param ids 需要删除的文档-文档信息主键
     * @return 结果
     */
    @Override
    public int deleteWdWdxxByIds(Long[] ids)
    {
        return wdWdxxMapper.deleteWdWdxxByIds(ids);
    }

    /**
     * 删除文档-文档信息信息
     *
     * @param id 文档-文档信息主键
     * @return 结果
     */
    @Override
    public int deleteWdWdxxById(Long id)
    {
        return wdWdxxMapper.deleteWdWdxxById(id);
    }
}
