package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.WdWdxxRd;
import com.qianhe.service.IWdWdxxRdService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 文档-热点信息Controller
 *
 * @author qianhe
 * @date 2024-09-14
 */
@RestController
@RequestMapping("/system/wdWdxxRd")
public class WdWdxxRdController extends BaseController
{
    @Autowired
    private IWdWdxxRdService wdWdxxRdService;

    /**
     * 查询文档-热点信息列表
     */
//    @PreAuthorize("@ss.hasPermi('system:wdWdxxRd:list')")
    @GetMapping("/list")
    public TableDataInfo list(WdWdxxRd wdWdxxRd)
    {
        startPage();
        List<WdWdxxRd> list = wdWdxxRdService.selectWdWdxxRdList(wdWdxxRd);
        return getDataTable(list);
    }

    /**
     * 导出文档-热点信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxxRd:export')")
    @Log(title = "文档-热点信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WdWdxxRd wdWdxxRd)
    {
        List<WdWdxxRd> list = wdWdxxRdService.selectWdWdxxRdList(wdWdxxRd);
        ExcelUtil<WdWdxxRd> util = new ExcelUtil<WdWdxxRd>(WdWdxxRd.class);
        util.exportExcel(response, list, "文档-热点信息数据");
    }

    /**
     * 获取文档-热点信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxxRd:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(wdWdxxRdService.selectWdWdxxRdById(id));
    }

    /**
     * 新增文档-热点信息
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxxRd:add')")
    @Log(title = "文档-热点信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WdWdxxRd wdWdxxRd)
    {
        return toAjax(wdWdxxRdService.insertWdWdxxRd(wdWdxxRd));
    }

    /**
     * 修改文档-热点信息
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxxRd:edit')")
    @Log(title = "文档-热点信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WdWdxxRd wdWdxxRd)
    {
        return toAjax(wdWdxxRdService.updateWdWdxxRd(wdWdxxRd));
    }

    /**
     * 删除文档-热点信息
     */
    @PreAuthorize("@ss.hasPermi('system:wdWdxxRd:remove')")
    @Log(title = "文档-热点信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(wdWdxxRdService.deleteWdWdxxRdByIds(ids));
    }
}
