package com.qianhe.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.domain.SjGfjsZsdwkhpjZb;
import com.qianhe.service.ISjGfjsJcdwkhpjZbService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 规范建设-基层单位考核评价主Controller
 *
 * @author qianhe
 * @date 2024-07-24
 */
@RestController
@RequestMapping("/system/sjGfjsJcdwkhpjZb")
public class SjGfjsJcdwkhpjZbController extends BaseController
{
    @Autowired
    private ISjGfjsJcdwkhpjZbService sjGfjsZsdwkhpjZbService;


    /**
     * 查询规范建设-基层单位考核评价主列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb)
    {
        startPage();
        List<SjGfjsZsdwkhpjZb> list = sjGfjsZsdwkhpjZbService.selectSjGfjsZsdwkhpjZbList(sjGfjsZsdwkhpjZb);
        return getDataTable(list);
    }




    /**
     * 导出规范建设-基层单位考核评价主列表
     */
    @Log(title = "规范建设-基层单位考核评价主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb)
    {
        List<SjGfjsZsdwkhpjZb> list = sjGfjsZsdwkhpjZbService.selectSjGfjsZsdwkhpjZbList(sjGfjsZsdwkhpjZb);
        ExcelUtil<SjGfjsZsdwkhpjZb> util = new ExcelUtil<SjGfjsZsdwkhpjZb>(SjGfjsZsdwkhpjZb.class);
        util.exportExcel(response, list, "规范建设-基层单位考核评价主数据");
    }

    /**
     * 获取规范建设-基层单位考核评价主详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsZsdwkhpjZbService.selectSjGfjsZsdwkhpjZbById(id));
    }

    /**
     * 新增规范建设-基层单位考核评价主
     */
    @Log(title = "规范建设-基层单位考核评价主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb)
    {
        return toAjax(sjGfjsZsdwkhpjZbService.insertSjGfjsZsdwkhpjZb(sjGfjsZsdwkhpjZb));
    }

    /**
     * 修改规范建设-基层单位考核评价主
     */
    @Log(title = "规范建设-基层单位考核评价主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsZsdwkhpjZb sjGfjsZsdwkhpjZb)
    {
        return toAjax(sjGfjsZsdwkhpjZbService.updateSjGfjsZsdwkhpjZb(sjGfjsZsdwkhpjZb));
    }

    /**
     * 删除规范建设-基层单位考核评价主
     */
    @Log(title = "规范建设-基层单位考核评价主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsZsdwkhpjZbService.deleteSjGfjsZsdwkhpjZbByIds(ids));
    }
}
