package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjZdbfKhpjbzCb;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjZdbfKhpjbz;
import com.qianhe.service.ISjZdbfKhpjbzService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 指导帮扶-考核评价标准Controller
 *
 * @author qianhe
 * @date 2024-07-22
 */
@RestController
@RequestMapping("/system/sjZdbfKhpjbz")
public class SjZdbfKhpjbzController extends BaseController
{
    @Autowired
    private ISjZdbfKhpjbzService sjZdbfKhpjbzService;

    /**
     * 查询指导帮扶-考核评价标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfKhpjbz:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZdbfKhpjbz sjZdbfKhpjbz)
    {
        startPage();
        List<SjZdbfKhpjbz> list = sjZdbfKhpjbzService.selectSjZdbfKhpjbzList(sjZdbfKhpjbz);
        return getDataTable(list);
    }


    /**
     * 查询指导帮扶-考核评价标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfKhpjbz:cxlist')")
    @GetMapping("/cxlist")
    public TableDataInfo cxlist(SjZdbfKhpjbz sjZdbfKhpjbz)
    {
//        startPage();
        List<SjZdbfKhpjbz> list = sjZdbfKhpjbzService.selectSjZdbfKhpjbzCxList(sjZdbfKhpjbz);
        return getDataTable(list);
    }

    /**
     * 导出指导帮扶-考核评价标准列表
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfKhpjbz:export')")
    @Log(title = "指导帮扶-考核评价标准", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZdbfKhpjbz sjZdbfKhpjbz)
    {
        List<SjZdbfKhpjbz> list = sjZdbfKhpjbzService.selectSjZdbfKhpjbzList(sjZdbfKhpjbz);
        ExcelUtil<SjZdbfKhpjbz> util = new ExcelUtil<SjZdbfKhpjbz>(SjZdbfKhpjbz.class);
        util.exportExcel(response, list, "指导帮扶-考核评价标准数据");
    }

    /**
     * 获取指导帮扶-考核评价标准详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfKhpjbz:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZdbfKhpjbzService.selectSjZdbfKhpjbzById(id));
    }

    /**
     * 新增指导帮扶-考核评价标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfKhpjbz:add')")
    @Log(title = "指导帮扶-考核评价标准", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZdbfKhpjbz sjZdbfKhpjbz)
    {
        return toAjax(sjZdbfKhpjbzService.insertSjZdbfKhpjbz(sjZdbfKhpjbz));
    }

    /**
     * 修改指导帮扶-考核评价标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfKhpjbz:edit')")
    @Log(title = "指导帮扶-考核评价标准", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZdbfKhpjbz sjZdbfKhpjbz)
    {
        return toAjax(sjZdbfKhpjbzService.updateSjZdbfKhpjbz(sjZdbfKhpjbz));
    }

    /**
     * 删除指导帮扶-考核评价标准
     */
//    @PreAuthorize("@ss.hasPermi('system:sjZdbfKhpjbz:remove')")
    @Log(title = "指导帮扶-考核评价标准", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZdbfKhpjbzService.deleteSjZdbfKhpjbzByIds(ids));
    }

    /**
     * 查询考核内容集合
     * @param cb
     * @return
     */
    @GetMapping("/getKhnrList")
    public AjaxResult getKhnrList(SjZdbfKhpjbzCb cb){

        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        if(StringUtils.isEmpty(cb.getLx())){
            return AjaxResult.error("该单位未设置类型");
        }
        List<String> khnrList = sjZdbfKhpjbzService.getKhnrList(cb);
        return success(khnrList);
    }


    /**
     * 查询考核项点集合
     * @param cb
     * @return
     */
    @GetMapping("/getKhxdList")
    public AjaxResult getKhxdList(SjZdbfKhpjbzCb cb){
        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        return success(sjZdbfKhpjbzService.getKhxdList(cb));
    }

    /**
     * 查询考核项点集合
     * @param cb
     * @return
     */
    @GetMapping("/getPjbzList")
    public AjaxResult getPjbzList(SjZdbfKhpjbzCb cb){
        String nd = cb.getNd();
        cb.setNd(nd.substring(0,4));
        return success(sjZdbfKhpjbzService.getPjbzList(cb));
    }

}
