package com.qianhe.service.impl;

import java.util.List;
import java.util.Map;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.core.domain.entity.SysUser;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.WdLxwh;
import com.qianhe.domain.WdWdxx;
import com.qianhe.mapper.WdLxwhMapper;
import com.qianhe.mapper.WdWdxxMapper;
import com.qianhe.system.mapper.SysDeptMapper;
import com.qianhe.system.mapper.SysUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.qianhe.mapper.WdWdwhMapper;
import com.qianhe.domain.WdWdwh;
import com.qianhe.service.IWdWdwhService;

/**
 * 文档-文档维护Service业务层处理
 *
 * @author qianhe
 * @date 2024-02-28
 */
@Service
public class WdWdwhServiceImpl implements IWdWdwhService
{
    @Autowired
    private WdWdwhMapper wdWdwhMapper;
    @Autowired
    private WdLxwhMapper wdLxwhMapper;
    @Autowired
    private WdWdxxMapper wdWdxxMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysDeptMapper sysDeptMapper;

    /**
     * 查询文档-文档维护
     *
     * @param id 文档-文档维护主键
     * @return 文档-文档维护
     */
    @Override
    public WdWdwh selectWdWdwhById(Long id)
    {
        WdWdwh wdWdwh = wdWdwhMapper.selectWdWdwhById(id);
        WdWdxx wdWdxx=new WdWdxx();
        wdWdxx.setGlId(wdWdwh.getId().toString());
        wdWdxx.setMkmc("文档维护");
        wdWdxx.setFjlx(wdWdwh.getTypeName());
        List<WdWdxx> wdWdxxes = wdWdxxMapper.selectWdWdxxList(wdWdxx);
        wdWdwh.setFileList(wdWdxxes);
        return wdWdwh;
    }

    /**
     * 查询文档-文档维护列表
     *
     * @param wdWdwh 文档-文档维护
     * @return 文档-文档维护
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<WdWdwh> selectWdWdwhList(WdWdwh wdWdwh)
    {
        List<WdWdwh> list = wdWdwhMapper.selectWdWdwhList(wdWdwh);
        List<WdWdxx> wdxxList = wdWdxxMapper.selectWdWdxxList(new WdWdxx());
        List<SysUser> userList = sysUserMapper.selectUserList(new SysUser());
        list.forEach(item->{
            //查询附件信息
            WdWdxx wdWdxx = wdxxList.stream().filter(file -> item.getId().toString().equals(file.getGlId())).findFirst().orElse(null);
            if(wdWdxx!=null){
                item.setFjmc(wdWdxx.getFjmc());
                item.setFjdz(wdWdxx.getFjdz());
                item.setScsj(wdWdxx.getLrsj());
                if(StringUtils.isNotEmpty(wdWdxx.getLrr())){
                    SysUser sysUser = userList.stream().filter(user -> user.getUserName().equals(wdWdxx.getLrr())).findFirst().orElse(null);
                    if(sysUser!=null){
                        item.setScr(sysUser.getNickName());
                    }
                }
            }
        });
        return list;
    }

    /**
     * 新增文档-文档维护
     *
     * @param wdWdwh 文档-文档维护
     * @return 结果
     */
    @Override
    public int insertWdWdwh(WdWdwh wdWdwh)
    {
        List<WdLxwh> wdLxwhs = wdLxwhMapper.selectWdLxwhList(new WdLxwh());
        List<SysDept> deptList = sysDeptMapper.selectDeptList(new SysDept());
        // 上传文件
        if(wdWdwh.getFileList().size()>0){
            wdWdwh.getFileList().forEach(file->{
                //保存基础信息
                //查询类型名称
                if(StringUtils.isNotEmpty(wdWdwh.getTypeId())){
                    WdLxwh wdLxwh =wdLxwhs.stream().filter(type->type.getId().toString().equals(wdWdwh.getTypeId())).findFirst().orElse(null);
                    if(wdLxwh!=null){
                        wdWdwh.setTypeName(wdLxwh.getName());
                    }
                }
                //保存单位信息
                wdWdwh.setDeptId(SecurityUtils.getDeptId().toString());
                SysDept dept=deptList.stream().filter(sysDept->sysDept.getDeptId().toString().equals(wdWdwh.getDeptId())).findFirst().orElse(null);
                if(dept!=null){
                    wdWdwh.setDeptName(dept.getDeptName());
                    wdWdwh.setEjdeptId(dept.getParentId()+"");
                    if(wdWdwh.getEjdeptId()!=null){
                        SysDept deptP=deptList.stream().filter(sysDept->sysDept.getDeptId().toString().equals(wdWdwh.getEjdeptId())).findFirst().orElse(null);
                        if(deptP!=null){
                            wdWdwh.setEjdeptName(deptP.getDeptName());
                        }
                    }
                }
                wdWdwh.setLrr(SecurityUtils.getUsername());
                wdWdwhMapper.insertWdWdwh(wdWdwh);
                file.setGlId(wdWdwh.getId().toString());
                file.setMkmc("文档维护");
                file.setFjlx(wdWdwh.getTypeName());
                file.setLrr(SecurityUtils.getUsername());
                wdWdxxMapper.insertWdWdxx(file);
            });
        }else {
            //查询类型名称
            if(StringUtils.isNotEmpty(wdWdwh.getTypeId())){
                WdLxwh wdLxwh =wdLxwhs.stream().filter(type->type.getId().toString().equals(wdWdwh.getTypeId())).findFirst().orElse(null);
                if(wdLxwh!=null){
                    wdWdwh.setTypeName(wdLxwh.getName());
                }
            }
            //保存单位信息
            wdWdwh.setDeptId(SecurityUtils.getDeptId().toString());
            SysDept dept=deptList.stream().filter(sysDept->sysDept.getDeptId().toString().equals(wdWdwh.getDeptId())).findFirst().orElse(null);
            if(dept!=null){
                wdWdwh.setDeptName(dept.getDeptName());
                wdWdwh.setEjdeptId(dept.getParentId()+"");
                if(wdWdwh.getEjdeptId()!=null){
                    SysDept deptP=deptList.stream().filter(sysDept->sysDept.getDeptId().toString().equals(wdWdwh.getEjdeptId())).findFirst().orElse(null);
                    if(deptP!=null){
                        wdWdwh.setEjdeptName(deptP.getDeptName());
                    }
                }
            }
            wdWdwh.setLrr(SecurityUtils.getUsername());
            wdWdwhMapper.insertWdWdwh(wdWdwh);
        }
        return 1;
    }

    /**
     * 修改文档-文档维护
     *
     * @param wdWdwh 文档-文档维护
     * @return 结果
     */
    @Override
    public int updateWdWdwh(WdWdwh wdWdwh)
    {
        List<SysDept> deptList = sysDeptMapper.selectDeptList(new SysDept());
        //删除文件
        wdWdxxMapper.deleteWdWdxxByGlIdAndMkmc(wdWdwh.getId()+"","文档维护");
        //查询类型名称
        if(StringUtils.isNotEmpty(wdWdwh.getTypeId())){
            WdLxwh wdLxwh = wdLxwhMapper.selectWdLxwhById(Long.parseLong(wdWdwh.getTypeId()));
            if(wdLxwh!=null){
                wdWdwh.setTypeName(wdLxwh.getName());
            }
        }
        //保存单位信息
        wdWdwh.setDeptId(SecurityUtils.getDeptId().toString());
        SysDept dept=deptList.stream().filter(sysDept->sysDept.getDeptId().toString().equals(wdWdwh.getDeptId())).findFirst().orElse(null);
        if(dept!=null){
            wdWdwh.setDeptName(dept.getDeptName());
            wdWdwh.setEjdeptId(dept.getParentId()+"");
            if(wdWdwh.getEjdeptId()!=null){
                SysDept deptP=deptList.stream().filter(sysDept->sysDept.getDeptId().toString().equals(wdWdwh.getEjdeptId())).findFirst().orElse(null);
                if(deptP!=null){
                    wdWdwh.setEjdeptName(deptP.getDeptName());
                }
            }
        }
        wdWdwh.setXgr(SecurityUtils.getUsername());
        int i1 = wdWdwhMapper.updateWdWdwh(wdWdwh);
        // 上传文件
        for(int i=0;i<wdWdwh.getFileList().size();i++){
            WdWdxx file=wdWdwh.getFileList().get(i);
            if(i==0){
                //更新第一个文件
                file.setGlId(wdWdwh.getId().toString());
                file.setMkmc("文档维护");
                file.setFjlx(wdWdwh.getTypeName());
                file.setLrr(SecurityUtils.getUsername());
                wdWdxxMapper.insertWdWdxx(file);
                continue;
            }
            //剩余文件改为新增
            wdWdwhMapper.insertWdWdwh(wdWdwh);
            file.setGlId(wdWdwh.getId().toString());
            file.setMkmc("文档维护");
            file.setFjlx(wdWdwh.getTypeName());
            file.setLrr(SecurityUtils.getUsername());
            wdWdxxMapper.insertWdWdxx(file);
        }
        return i1;
    }

    /**
     * 批量删除文档-文档维护
     *
     * @param ids 需要删除的文档-文档维护主键
     * @return 结果
     */
    @Override
    public int deleteWdWdwhByIds(Long[] ids)
    {
        return wdWdwhMapper.deleteWdWdwhByIds(ids);
    }

    /**
     * 删除文档-文档维护信息
     *
     * @param id 文档-文档维护主键
     * @return 结果
     */
    @Override
    public int deleteWdWdwhById(Long id)
    {
        return wdWdwhMapper.deleteWdWdwhById(id);
    }

    @Override
    public List<WdWdwh> getListBySjDw(WdWdwh wdWdwh) {
        return wdWdwhMapper.getListBySjDw(wdWdwh);
    }

    @Override
    public List<Map> getListBySjDwByType(WdWdwh wdWdwh) {
        return wdWdwhMapper.getListBySjDwByType(wdWdwh);
    }

    @Override
    public List<WdWdwh> getListByEjDw(WdWdwh wdWdwh) {
        return wdWdwhMapper.getListByEjDw(wdWdwh);
    }

    @Override
    public List<Map> getListByEjDwByType(WdWdwh wdWdwh) {
        return wdWdwhMapper.getListByEjDwByType(wdWdwh);
    }

    @Override
    public List<WdWdxx> getFileList(WdWdwh wdWdwh) {
        return wdWdwhMapper.getFileList(wdWdwh);
    }
}
