package com.qianhe.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.qianhe.domain.SjZdbfZsdwkhpj;
import com.qianhe.service.ISjZdbfZsdwkhpjService;
import com.qianhe.service.ISjZdbfZsdwkhpjfjxService;
import com.qianhe.system.mapper.SysDeptMapper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjZdbfZsdwkhpjZb;
import com.qianhe.service.ISjZdbfZsdwkhpjZbService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 指导帮扶-直属单位考核评价主Controller
 *
 * @author qianhe
 * @date 2024-07-24
 */
@RestController
@RequestMapping("/system/sjZdbfZsdwkhpjZb")
public class SjZdbfZsdwkhpjZbController extends BaseController
{
    @Autowired
    private ISjZdbfZsdwkhpjZbService sjZdbfZsdwkhpjZbService;


    /**
     * 查询指导帮扶-直属单位考核评价主列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfZsdwkhpjZb:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        startPage();
        List<SjZdbfZsdwkhpjZb> list = sjZdbfZsdwkhpjZbService.selectSjZdbfZsdwkhpjZbList(sjZdbfZsdwkhpjZb);
        return getDataTable(list);
    }




    /**
     * 导出指导帮扶-直属单位考核评价主列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfZsdwkhpjZb:export')")
    @Log(title = "指导帮扶-直属单位考核评价主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        List<SjZdbfZsdwkhpjZb> list = sjZdbfZsdwkhpjZbService.selectSjZdbfZsdwkhpjZbList(sjZdbfZsdwkhpjZb);
        ExcelUtil<SjZdbfZsdwkhpjZb> util = new ExcelUtil<SjZdbfZsdwkhpjZb>(SjZdbfZsdwkhpjZb.class);
        util.exportExcel(response, list, "指导帮扶-直属单位考核评价主数据");
    }

    /**
     * 获取指导帮扶-直属单位考核评价主详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfZsdwkhpjZb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZdbfZsdwkhpjZbService.selectSjZdbfZsdwkhpjZbById(id));
    }

    /**
     * 新增指导帮扶-直属单位考核评价主
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfZsdwkhpjZb:add')")
    @Log(title = "指导帮扶-直属单位考核评价主", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        return toAjax(sjZdbfZsdwkhpjZbService.insertSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb));
    }

    /**
     * 修改指导帮扶-直属单位考核评价主
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfZsdwkhpjZb:edit')")
    @Log(title = "指导帮扶-直属单位考核评价主", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZdbfZsdwkhpjZb sjZdbfZsdwkhpjZb)
    {
        return toAjax(sjZdbfZsdwkhpjZbService.updateSjZdbfZsdwkhpjZb(sjZdbfZsdwkhpjZb));
    }

    /**
     * 删除指导帮扶-直属单位考核评价主
     */
    @PreAuthorize("@ss.hasPermi('system:sjZdbfZsdwkhpjZb:remove')")
    @Log(title = "指导帮扶-直属单位考核评价主", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZdbfZsdwkhpjZbService.deleteSjZdbfZsdwkhpjZbByIds(ids));
    }
}
