package com.qianhe.controller;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.javaex.officejj.word.WordUtils;
import com.alibaba.fastjson2.JSONObject;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.Vo.SjLhscVo;

import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.domain.SjLhsc;
import com.qianhe.service.ISjLhscService;
import com.qianhe.common.utils.poi.ExcelUtil;
import com.qianhe.common.core.page.TableDataInfo;

/**
 * 三基-例会上传Controller
 *
 * @author qianhe
 * @date 2024-07-08
 */
@RestController
@RequestMapping("/system/sjLhsc")
public class SjLhscController extends BaseController
{
    @Autowired
    private ISjLhscService sjLhscService;

    /**
     * 查询三基-例会上传列表(二级单位)
     */

    @GetMapping("/list")
    public TableDataInfo list(SjLhsc sjLhsc)
    {
        startPage();
        String nd="";
        if(StringUtils.isNotEmpty(sjLhsc.getNd())){
            nd=sjLhsc.getNd();
            String startJd="";
            String endJd="";
            if(StringUtils.isNotEmpty(sjLhsc.getJd())){
                String jd=sjLhsc.getJd();
                if("1".equals(jd)){
                    startJd=nd+"-01";
                    endJd=nd+"-03";
                }else if("2".equals(jd)){
                    startJd=nd+"-04";
                    endJd=nd+"-06";
                }if("3".equals(jd)){
                    startJd=nd+"-07";
                    endJd=nd+"-09";
                }if("4".equals(jd)){
                    startJd=nd+"-10";
                    endJd=nd+"-12";
                }else{
                    startJd=nd+"-01";
                    endJd=nd+"-12";
                }
            }else{
                startJd=nd+"-01";
                endJd=nd+"-12";
            }
            sjLhsc.setStartJd(startJd);
            sjLhsc.setEndJd(endJd);
        }


        List<SjLhsc> list = sjLhscService.selectSjLhscList(sjLhsc);
        return getDataTable(list);
    }

    /**
     * 查询三基-例会上传列表(三级单位)
     */

    @GetMapping("/listBySj")
    public TableDataInfo listBySj(SjLhsc sjLhsc)
    {
        startPage();
        String nd="";
        if(StringUtils.isNotEmpty(sjLhsc.getNd())){
            nd=sjLhsc.getNd();
            String startJd="";
            String endJd="";
            if(StringUtils.isNotEmpty(sjLhsc.getJd())){
                String jd=sjLhsc.getJd();
                if("1".equals(jd)){
                    startJd=nd+"-01";
                    endJd=nd+"-03";
                }else if("2".equals(jd)){
                    startJd=nd+"-04";
                    endJd=nd+"-06";
                }if("3".equals(jd)){
                    startJd=nd+"-07";
                    endJd=nd+"-09";
                }if("4".equals(jd)){
                    startJd=nd+"-10";
                    endJd=nd+"-12";
                }else{
                    startJd=nd+"-01";
                    endJd=nd+"-12";
                }
            }else{
                startJd=nd+"-01";
                endJd=nd+"-12";
            }
            sjLhsc.setStartJd(startJd);
            sjLhsc.setEndJd(endJd);
        }
        List<SjLhsc> list = sjLhscService.selectSjLhscList(sjLhsc);
        return getDataTable(list);
    }
    /**
     * 导出三基-例会上传列表
     */

    @Log(title = "三基-例会上传", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjLhsc sjLhsc)
    {
        List<SjLhsc> list = sjLhscService.selectSjLhscList(sjLhsc);
        ExcelUtil<SjLhsc> util = new ExcelUtil<SjLhsc>(SjLhsc.class);
        util.exportExcel(response, list, "三基-例会上传数据");
    }

    /**
     * 获取三基-例会上传详细信息
     */

    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjLhscService.selectSjLhscById(id));
    }

    /**
     * 新增三基-例会上传
     */

    @Log(title = "三基-例会上传", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjLhsc sjLhsc) throws Exception {
        sjLhsc.setYxqk(URLDecoder.decode(sjLhsc.getYxqk(), "utf-8"));
        sjLhsc.setJjwt(URLDecoder.decode(sjLhsc.getJjwt(), "utf-8"));
        sjLhsc.setTgjy(URLDecoder.decode(sjLhsc.getTgjy(), "utf-8"));
        sjLhsc.setLdyq(URLDecoder.decode(sjLhsc.getLdyq(), "utf-8"));
        sjLhsc.setCzwt(URLDecoder.decode(sjLhsc.getCzwt(), "utf-8"));
        return toAjax(sjLhscService.insertSjLhsc(sjLhsc));
    }

    /**
     * 修改三基-例会上传
     */

    @Log(title = "三基-例会上传", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjLhsc sjLhsc) throws UnsupportedEncodingException {
        sjLhsc.setYxqk(URLDecoder.decode(sjLhsc.getYxqk(), "utf-8"));
        sjLhsc.setJjwt(URLDecoder.decode(sjLhsc.getJjwt(), "utf-8"));
        sjLhsc.setTgjy(URLDecoder.decode(sjLhsc.getTgjy(), "utf-8"));
        sjLhsc.setLdyq(URLDecoder.decode(sjLhsc.getLdyq(), "utf-8"));
        sjLhsc.setCzwt(URLDecoder.decode(sjLhsc.getCzwt(), "utf-8"));
        return toAjax(sjLhscService.updateSjLhsc(sjLhsc));
    }

    /**
     * 删除三基-例会上传
     */

    @Log(title = "三基-例会上传", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjLhscService.deleteSjLhscByIds(ids));
    }


    /**
     * 提交
     */

    @Log(title = "三基-例会上传", businessType = BusinessType.UPDATE)
    @PostMapping("/tj")
    public AjaxResult tj(@RequestBody SjLhsc sjLhsc)
    {
        return toAjax(sjLhscService.tj(sjLhsc));
    }


    /**
     * 查询三基-例会上传已提交列表
     */

    @GetMapping("/listYtj")
    public TableDataInfo listYtj(SjLhsc sjLhsc)
    {
        startPage();
        sjLhsc.setZt("已提交");
        List<SjLhsc> list = sjLhscService.selectSjLhscList(sjLhsc);
        return getDataTable(list);
    }

    public String escapespecialcharacters(String input) {
        if(StringUtils.isEmpty(input)){
            return "";
        }
        String escaped = input.replaceAll("&gt;", ">")
                .replaceAll("&lt;", "<")
                .replaceAll("&lt;=", "<=")
                .replaceAll("&gt;=", "<=");
        return escaped;
    }

    /**
     * 统计是否上传(三级)
     * @return
     */
    @GetMapping("/tjBysfsc")
    public TableDataInfo tjBysfsc(SjLhscVo vo)
    {
        vo.setDwjb("4");
        String nd="";
        if(StringUtils.isNotEmpty(vo.getNd())){
            nd=vo.getNd();
        }
        String startJd="";
        String endJd="";
        if(StringUtils.isNotEmpty(vo.getJd())){
            String jd=vo.getJd();
            if("1".equals(jd)){
                startJd=nd+"-01";
                endJd=nd+"-03";
            }else if("2".equals(jd)){
                startJd=nd+"-04";
                endJd=nd+"-06";
            }if("3".equals(jd)){
                startJd=nd+"-07";
                endJd=nd+"-09";
            }if("4".equals(jd)){
                startJd=nd+"-10";
                endJd=nd+"-12";
            }
        }
        vo.setStartJd(startJd);
        vo.setEndJd(endJd);
        List<SjLhscVo> list = sjLhscService.tjBysfsc(vo);
        return getDataTable(list);
    }


    /**
     * 统计是否上传(二级)
     * @return
     */
    @GetMapping("/tjByEjSfsc")
    public TableDataInfo tjByEjSfsc(SjLhscVo vo)
    {
        vo.setDwjb("3");
        String nd="";
        if(StringUtils.isNotEmpty(vo.getNd())){
            nd=vo.getNd();
        }
        String startJd="";
        String endJd="";
        if(StringUtils.isNotEmpty(vo.getJd())){
            String jd=vo.getJd();
            if("1".equals(jd)){
                startJd=nd+"-01";
                endJd=nd+"-03";
            }else if("2".equals(jd)){
                startJd=nd+"-04";
                endJd=nd+"-06";
            }if("3".equals(jd)){
                startJd=nd+"-07";
                endJd=nd+"-09";
            }if("4".equals(jd)){
                startJd=nd+"-10";
                endJd=nd+"-12";
            }
        }
        vo.setStartJd(startJd);
        vo.setEndJd(endJd);
        List<SjLhscVo> list = sjLhscService.tjBysfsc(vo);
        return getDataTable(list);
    }

    /**
     * 统计解决问题数量(二级)
     * @return
     */
    @GetMapping("/tjByEjJjwtSl")
    public TableDataInfo tjByEjJjwtSl(SjLhscVo vo)
    {
        vo.setDwjb("3");
        String nd="";
        if(StringUtils.isNotEmpty(vo.getNd())){
            nd=vo.getNd();
        }
        String startJd="";
        String endJd="";
        if(StringUtils.isNotEmpty(vo.getJd())){
            String jd=vo.getJd();
            if("1".equals(jd)){
                startJd=nd+"-01";
                endJd=nd+"-03";
            }else if("2".equals(jd)){
                startJd=nd+"-04";
                endJd=nd+"-06";
            }if("3".equals(jd)){
                startJd=nd+"-07";
                endJd=nd+"-09";
            }if("4".equals(jd)){
                startJd=nd+"-10";
                endJd=nd+"-12";
            }
        }
        vo.setStartJd(startJd);
        vo.setEndJd(endJd);
        List<SjLhscVo> list = sjLhscService.tjByEjJjwtSl(vo);
        return getDataTable(list);
    }


    /**
     * 统计解决问题数量(三级)
     * @return
     */
    @GetMapping("/tjBySjJjwtSl")
    public TableDataInfo tjBySjJjwtSl(SjLhscVo vo)
    {
        vo.setDwjb("4");
        String nd="";
        if(StringUtils.isNotEmpty(vo.getNd())){
            nd=vo.getNd();
        }
        String startJd="";
        String endJd="";
        if(StringUtils.isNotEmpty(vo.getJd())){
            String jd=vo.getJd();
            if("1".equals(jd)){
                startJd=nd+"-01";
                endJd=nd+"-03";
            }else if("2".equals(jd)){
                startJd=nd+"-04";
                endJd=nd+"-06";
            }if("3".equals(jd)){
                startJd=nd+"-07";
                endJd=nd+"-09";
            }if("4".equals(jd)){
                startJd=nd+"-10";
                endJd=nd+"-12";
            }
        }
        vo.setStartJd(startJd);
        vo.setEndJd(endJd);
        List<SjLhscVo> list = sjLhscService.tjByEjJjwtSl(vo);
        return getDataTable(list);
    }



    /**
     * 例会共享
     */
    @GetMapping("/listYtjLhgx")
    public TableDataInfo listYtjLhgx(SjLhsc sjLhsc)
    {
        startPage();
        sjLhsc.setZt("已提交");
        String nd="";
        if(StringUtils.isNotEmpty(sjLhsc.getNd())){
            nd=sjLhsc.getNd();
        }
        String startJd="";
        String endJd="";
        if(StringUtils.isNotEmpty(sjLhsc.getJd())){
            String jd=sjLhsc.getJd();
            if("1".equals(jd)){
                startJd=nd+"-01";
                endJd=nd+"-03";
            }else if("2".equals(jd)){
                startJd=nd+"-04";
                endJd=nd+"-06";
            }if("3".equals(jd)){
                startJd=nd+"-07";
                endJd=nd+"-09";
            }if("4".equals(jd)){
                startJd=nd+"-10";
                endJd=nd+"-12";
            }
        }
        sjLhsc.setStartJd(startJd);
        sjLhsc.setEndJd(endJd);

        List<SjLhsc> list = sjLhscService.selectSjLhscLhgxList(sjLhsc);
        return getDataTable(list);
    }

    /**
     * 例会共享
     */
    @GetMapping("/getInfoLhgx/{id}")
    public AjaxResult getInfoLhgx(@PathVariable("id") Long id)
    {
        return success(sjLhscService.selectSjLhscById(id));
    }


    /**
     * 导出word
     * @param response
     */
    @PostMapping("/export_word")
    public void export_word(HttpServletResponse response, SjLhsc sjLhsc) throws Exception {
        SjLhsc sjLhsc1 = sjLhscService.selectSjLhscById(sjLhsc.getId());
        //获取模板
        XWPFDocument word = WordUtils.getDocxFromResource("/wordTemp/lhmb.docx");
        String s = JSONObject.toJSONString(sjLhsc1);
        Map<String,Object> map = JSONObject.parseObject(s, Map.class);
        map.put("hyrq", DateUtils.parseDateToStr("yyyy-MM-dd",sjLhsc1.getHyrq()));
        XWPFDocument word1 = WordUtils.writeDocx(word, map);
        WordUtils.download(response, word1, sjLhsc1.getHymc()+".docx");
    }


}
