package com.qianhe.domain;

import java.util.List;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 指导帮扶-否决项标准对象 sj_zdbf_fjxbz
 *
 * @author qianhe
 * @date 2024-07-22
 */
@Data
public class SjZdbfFjxbz extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 年度 */
    @Excel(name = "年度")
    private String nd;

    /** 分类名称 */
    @Excel(name = "分类名称")
    private String flmc;

    /** 考核项点排序 */
    @Excel(name = "考核项点排序")
    private Long px;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    private String pjbz;

    /** 指导帮扶-否决项标准从信息 */
    private List<SjZdbfFjxbzCb> sjZdbfFjxbzCbList;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setNd(String nd)
    {
        this.nd = nd;
    }

    public String getNd()
    {
        return nd;
    }
    public void setFlmc(String flmc)
    {
        this.flmc = flmc;
    }

    public String getFlmc()
    {
        return flmc;
    }
    public void setPx(Long px)
    {
        this.px = px;
    }

    public Long getPx()
    {
        return px;
    }
    public void setYl1(String yl1)
    {
        this.yl1 = yl1;
    }

    public String getYl1()
    {
        return yl1;
    }
    public void setYl2(String yl2)
    {
        this.yl2 = yl2;
    }

    public String getYl2()
    {
        return yl2;
    }
    public void setYl3(String yl3)
    {
        this.yl3 = yl3;
    }

    public String getYl3()
    {
        return yl3;
    }
    public void setYl4(String yl4)
    {
        this.yl4 = yl4;
    }

    public String getYl4()
    {
        return yl4;
    }
    public void setYl5(String yl5)
    {
        this.yl5 = yl5;
    }

    public String getYl5()
    {
        return yl5;
    }

    public List<SjZdbfFjxbzCb> getSjZdbfFjxbzCbList()
    {
        return sjZdbfFjxbzCbList;
    }

    public void setSjZdbfFjxbzCbList(List<SjZdbfFjxbzCb> sjZdbfFjxbzCbList)
    {
        this.sjZdbfFjxbzCbList = sjZdbfFjxbzCbList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("nd", getNd())
            .append("flmc", getFlmc())
            .append("px", getPx())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("yl1", getYl1())
            .append("yl2", getYl2())
            .append("yl3", getYl3())
            .append("yl4", getYl4())
            .append("yl5", getYl5())
            .append("sjZdbfFjxbzCbList", getSjZdbfFjxbzCbList())
            .toString();
    }
}
