package com.qianhe.controller;

import com.qianhe.common.annotation.Log;
import com.qianhe.common.core.controller.BaseController;
import com.qianhe.common.core.domain.AjaxResult;
import com.qianhe.common.core.domain.entity.SysDept;
import com.qianhe.common.core.page.TableDataInfo;
import com.qianhe.common.enums.BusinessType;
import com.qianhe.common.exception.BusinessException;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjGfjsKhwtCb;
import com.qianhe.domain.SjGfjsYdjcjl;
import com.qianhe.domain.SjGfjsZsdwfjxcj;
import com.qianhe.mapper.SjGfjsKhwtMapper;
import com.qianhe.service.ISjGfjsZsdwfjxcjService;
import com.qianhe.system.mapper.SysDeptMapper;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 规范建设-直属单位否决项采集Controller
 * 现机关单位否决项采集
 * @author qianhe
 * @date 2024-07-24
 */
@RestController
@RequestMapping("/system/sjGfjsZsdwfjxcj")
public class SjGfjsZsdwfjxcjController extends BaseController
{
    @Autowired
    private ISjGfjsZsdwfjxcjService sjGfjsZsdwfjxcjService;

    @Autowired
    private SysDeptMapper sysDeptMapper;

    @Autowired
    private SjGfjsKhwtMapper sjGfjsKhwtMapper;
    /**
     * 查询规范建设-直属单位否决项采集列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SjGfjsZsdwfjxcj sjGfjsZsdwfjxcj)
    {
        startPage();
        List<SjGfjsZsdwfjxcj> list = sjGfjsZsdwfjxcjService.selectSjGfjsZsdwfjxcjList(sjGfjsZsdwfjxcj);
        return getDataTable(list);
    }

    /**
     * 导出规范建设-直属单位否决项采集列表
     */
    @Log(title = "规范建设-直属单位否决项采集", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjGfjsZsdwfjxcj sjGfjsZsdwfjxcj)
    {
        Workbook exl = null;
        OutputStream out = null;
        InputStream in  = null;
        try {
            in =this.getClass().getResourceAsStream("/static/gfjs_zsdwfjxcj.xlsx");
            exl = WorkbookFactory.create(in);
            out = response.getOutputStream();
            response.reset();
            String filename = URLEncoder.encode("否决项采集模板.xlsx", "UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
            exl.write(out);
            exl.close();
        }catch(Exception e){
            e.getMessage();
            throw new BusinessException("导出Excel失败，请联系网站管理员！");
        }finally{
            if (exl != null) {
                try {
                    exl.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /**
     * 获取规范建设-直属单位否决项采集详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjGfjsZsdwfjxcjService.selectSjGfjsZsdwfjxcjById(id));
    }

    /**
     * 新增规范建设-直属单位否决项采集
     */
    @Log(title = "规范建设-直属单位否决项采集", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjGfjsZsdwfjxcj sjGfjsZsdwfjxcj)
    {
        return toAjax(sjGfjsZsdwfjxcjService.insertSjGfjsZsdwfjxcj(sjGfjsZsdwfjxcj));
    }

    /**
     * 修改规范建设-直属单位否决项采集
     */
    @Log(title = "规范建设-直属单位否决项采集", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjGfjsZsdwfjxcj sjGfjsZsdwfjxcj)
    {
        return toAjax(sjGfjsZsdwfjxcjService.updateSjGfjsZsdwfjxcj(sjGfjsZsdwfjxcj));
    }

    /**
     * 删除规范建设-直属单位否决项采集
     */
    @Log(title = "规范建设-直属单位否决项采集", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjGfjsZsdwfjxcjService.deleteSjGfjsZsdwfjxcjByIds(ids));
    }


    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception{

        XSSFWorkbook workbook = null;
        List<SysDept> deptList = sysDeptMapper.selectDeptList(new SysDept());

        try {
            //装载流
            workbook = new XSSFWorkbook(file.getInputStream());

            // 获取一个工作表，下标从0开始
            XSSFSheet sheet = workbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            List<SjGfjsZsdwfjxcj> list=new ArrayList<>();
            // 通过循环，逐行取出表中每行数据
            for(int i=0;i<=lastRowNum;i++) {//跳过第一行和第二行
                if(i==0 || i==1){
                    continue;
                }
                // 获取行
                XSSFRow row = sheet.getRow(i);
                SjGfjsZsdwfjxcj zsdwwtcj=new SjGfjsZsdwfjxcj();
                System.out.println(row);
                //日期
                String rq=new DataFormatter().formatCellValue(row.getCell(1));
                if(StringUtils.isEmpty(rq)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行日期不能为空");
                }
                Date date = DateUtils.parseDate(rq);
                if(date==null){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行日期格式错误");
                }
                zsdwwtcj.setRq(DateUtils.parseDateToStr("yyyy-MM",date));

                //机关部门
                String jgbm=new DataFormatter().formatCellValue(row.getCell(2)) ;
                if(StringUtils.isEmpty(jgbm)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行机关部门不能为空");
                }
                String[] jgsplit = jgbm.split("/");
                if(jgsplit.length==1){
                    String bm=jgsplit[0]; // 部门
                    SysDept bmdept = deptList.stream().filter(dept -> dept.getDeptName().equals(bm)).findFirst().orElse(null);
                    if(bmdept==null){
                        return AjaxResult.error("导入失败，第"+(i+1)+"行，机关部门：未匹配到机关名称");
                    }
                    zsdwwtcj.setYl3(bmdept.getDeptId());
                }else{
                    String bm=jgsplit[0];// 部门
                    String ks=jgsplit[1];// 科室
                    SysDept bmdept = deptList.stream().filter(dept -> dept.getDeptName().equals(bm)).findFirst().orElse(null);
                    if(bmdept==null){
                        return AjaxResult.error("导入失败，第"+(i+1)+"行，机关部门：未匹配到机关名称");
                    }
                    SysDept ksdept = deptList.stream().filter(dept -> dept.getDeptName().equals(ks) && dept.getParentId().equals(bmdept.getDeptId())).findFirst().orElse(null);
                    if(ksdept==null){
                        return AjaxResult.error("导入失败，第"+(i+1)+"行，机关部门：未匹配到科室名称");
                    }
                    zsdwwtcj.setYl3(ksdept.getDeptId());
                }

                //受检单位
                String dw=new DataFormatter().formatCellValue(row.getCell(3)) ;
                if(StringUtils.isEmpty(dw)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行受检单位不能为空");
                }
                //查询单位id
                String[] split = dw.split("/");
                if(split.length<2){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行输入的受检单位格式有误!");
                }
                String ejdw=split[0];
                SysDept ejdept = deptList.stream().filter(dept -> dept.getDeptName().equals(ejdw)).findFirst().orElse(null);
                if(ejdept==null){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行，受检单位:未匹配到二级单位");
                }
                String sjdw=split[1];
                SysDept sjdept = deptList.stream().filter(dept -> dept.getDeptName().equals(sjdw) && dept.getParentId().equals(ejdept.getDeptId())).findFirst().orElse(null);
                if(sjdept==null){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行,受检单位:未匹配到三级单位");
                }
                zsdwwtcj.setDeptId(sjdept.getDeptId());
                //分类名称
                String flmc=new DataFormatter().formatCellValue(row.getCell(4)) ;
                if(StringUtils.isEmpty(flmc)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行考核内容不能为空");
                }
                zsdwwtcj.setFlmc(flmc);
                //评价标准
                String pjbz=new DataFormatter().formatCellValue(row.getCell(5)) ;
                if(StringUtils.isEmpty(pjbz)){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行问题事项不能为空");
                }
                //匹配评价标准
                String substring = pjbz.substring(4);
                long l = Long.parseLong(substring);
                SjGfjsKhwtCb sjGfjsKhwtCb=new SjGfjsKhwtCb();
                sjGfjsKhwtCb.setFlmc(flmc);
                sjGfjsKhwtCb.setPx(l);
                sjGfjsKhwtCb.setNd(rq.substring(0,4));
                SjGfjsKhwtCb cb=sjGfjsKhwtMapper.selectSjGfjsKhwtCb(sjGfjsKhwtCb);
                if(cb==null){
                    return AjaxResult.error("导入失败，第"+(i+1)+"行未匹配到评价标准");
                }
                zsdwwtcj.setPjbzid(cb.getId()+"");
                zsdwwtcj.setPjbzmc(cb.getPjbz());
                String wtms=new DataFormatter().formatCellValue(row.getCell(6)) ;
                zsdwwtcj.setWtmc(wtms);
                zsdwwtcj.setCreateTime(DateUtils.getNowDate());
                zsdwwtcj.setCreateBy(SecurityUtils.getUsername());
                list.add(zsdwwtcj);
            }
            if(list.size()>0){
                sjGfjsZsdwfjxcjService.batchSave(list);
            }
        } catch (IOException e) {
            e.getMessage();
            e.printStackTrace();
            throw new BusinessException("导入Excel失败，请联系网站管理员！");

        } finally {
            workbook.close();
        }
        return AjaxResult.success("导入成功");
    }

    //批量提交 ids
    @Log(title = "否决项采集提交", businessType = BusinessType.UPDATE)
    @PostMapping("/pltj")
    public AjaxResult pltj(@RequestBody SjGfjsZsdwfjxcj fjx)
    {
        fjx.setZt("1");
        return toAjax(sjGfjsZsdwfjxcjService.plxg(fjx));
    }
}
