package com.qianhe.domain;

import java.math.BigDecimal;
import java.util.List;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;

/**
 * 三基-费用报批主对象 sj_fybp_zb
 *
 * @author qianhe
 * @date 2024-07-11
 */
@Data
public class SjFybpZb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 费用日期 */
    @Excel(name = "费用日期")
    private String fyrq;

    /** 单位 */
    @Excel(name = "单位")
    private String deptId;

    /** 费用金额 */
    @Excel(name = "费用金额")
    private BigDecimal fyje;

    /** 状态(未提交、待审批、已审批、已驳回) */
    @Excel(name = "状态(未提交、待审批、已审批、已驳回)")
    private String zt;

    /** 提交人 */
    @Excel(name = "提交人")
    private String tjr;

    /** 提交日期 */
    @Excel(name = "提交日期")
    private String tjrq;

    /** 审批日期 */
    @Excel(name = "审批日期")
    private String sprq;

    /** 审批人 */
    @Excel(name = "审批人")
    private String spr;

    /** 已使用金额 */
    @Excel(name = "已使用金额")
    private BigDecimal ysyje;

    /** 审批意见 */
    @Excel(name = "审批意见")
    private String spyj;

    /** 预留1 */
    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
    @Excel(name = "预留5")
    private String yl5;

    /** 三基-费用报批信息 */
    private List<SjFybp> sjFybpList;


    private List<WdWdxx> fileList;

    private String deptName;

    private String sprName;

    private String spcx;

    private String tqbz;
    private String jsbz;
    private String jl;

    private Boolean jlflag;
    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setFyrq(String fyrq)
    {
        this.fyrq = fyrq;
    }

    public String getFyrq()
    {
        return fyrq;
    }
    public void setDeptId(String deptId)
    {
        this.deptId = deptId;
    }

    public String getDeptId()
    {
        return deptId;
    }
    public void setFyje(BigDecimal fyje)
    {
        this.fyje = fyje;
    }

    public BigDecimal getFyje()
    {
        return fyje;
    }
    public void setZt(String zt)
    {
        this.zt = zt;
    }

    public String getZt()
    {
        return zt;
    }
    public void setTjr(String tjr)
    {
        this.tjr = tjr;
    }

    public String getTjr()
    {
        return tjr;
    }
    public void setTjrq(String tjrq)
    {
        this.tjrq = tjrq;
    }

    public String getTjrq()
    {
        return tjrq;
    }
    public void setSprq(String sprq)
    {
        this.sprq = sprq;
    }

    public String getSprq()
    {
        return sprq;
    }
    public void setSpr(String spr)
    {
        this.spr = spr;
    }

    public String getSpr()
    {
        return spr;
    }
    public void setYsyje(BigDecimal ysyje)
    {
        this.ysyje = ysyje;
    }

    public BigDecimal getYsyje()
    {
        return ysyje;
    }
    public void setSpyj(String spyj)
    {
        this.spyj = spyj;
    }

    public String getSpyj()
    {
        return spyj;
    }
    public void setYl1(String yl1)
    {
        this.yl1 = yl1;
    }

    public String getYl1()
    {
        return yl1;
    }
    public void setYl2(String yl2)
    {
        this.yl2 = yl2;
    }

    public String getYl2()
    {
        return yl2;
    }
    public void setYl3(String yl3)
    {
        this.yl3 = yl3;
    }

    public String getYl3()
    {
        return yl3;
    }
    public void setYl4(String yl4)
    {
        this.yl4 = yl4;
    }

    public String getYl4()
    {
        return yl4;
    }
    public void setYl5(String yl5)
    {
        this.yl5 = yl5;
    }

    public String getYl5()
    {
        return yl5;
    }

    public List<SjFybp> getSjFybpList()
    {
        return sjFybpList;
    }

    public void setSjFybpList(List<SjFybp> sjFybpList)
    {
        this.sjFybpList = sjFybpList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("fyrq", getFyrq())
            .append("deptId", getDeptId())
            .append("fyje", getFyje())
            .append("zt", getZt())
            .append("tjr", getTjr())
            .append("tjrq", getTjrq())
            .append("sprq", getSprq())
            .append("spr", getSpr())
            .append("ysyje", getYsyje())
            .append("spyj", getSpyj())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("yl1", getYl1())
            .append("yl2", getYl2())
            .append("yl3", getYl3())
            .append("yl4", getYl4())
            .append("yl5", getYl5())
            .append("sjFybpList", getSjFybpList())
            .toString();
    }
}
